/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import de.teamlapen.vampirism.modcompat.guide.GuideBook;
import de.teamlapen.vampirism.modcompat.guide.client.LinkedEntryScreen;
import java.net.URI;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PageHolderWithLinks
implements IPage {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IPage page;
    private final List<ResourceLocation> lateLinks = Lists.newArrayList();
    private final List<Link> links = Lists.newArrayList();
    private long lastLinkClick = 0L;

    public PageHolderWithLinks(IPage page) {
        this.page = page;
    }

    public PageHolderWithLinks addLink(EntryAbstract entry) {
        this.links.add(new EntryLink(entry));
        return this;
    }

    public PageHolderWithLinks addLink(ResourceLocation entry) {
        this.lateLinks.add(entry);
        return this;
    }

    public PageHolderWithLinks addLink(URLLink link) {
        this.links.add(link);
        return this;
    }

    public PageHolderWithLinks addLink(String resourceLocation) {
        this.addLink(new ResourceLocation(resourceLocation));
        return this;
    }

    public boolean canSee(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack, EntryScreen guiEntry) {
        return this.page.canSee(book, category, entry, player, bookStack, guiEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        this.page.draw(stack, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        int ll = guiLeft + guiBase.xSize - 5;
        int y = guiTop + 10;
        for (Link l : this.links) {
            fontRendererObj.func_238407_a_(stack, (ITextProperties)l.getDisplayName(), (float)ll, (float)y, 0xFFFFFF);
            if (l.width == 0) {
                l.width = fontRendererObj.func_238414_a_((ITextProperties)l.getDisplayName());
            }
            y += 20;
        }
        this.page.drawExtras(stack, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInit(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack, EntryScreen guiEntry) {
        while (this.lateLinks.size() > 0) {
            ResourceLocation s = this.lateLinks.remove(0);
            EntryAbstract e = GuideBook.getLinkedEntry(s);
            if (e == null) {
                LOGGER.warn("Failed to find linked entry {}", (Object)s);
                continue;
            }
            this.addLink(e);
        }
        this.page.onInit(book, category, entry, player, bookStack, guiEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onLeftClicked(Book book, CategoryAbstract category, EntryAbstract entry, double mouseX, double mouseY, PlayerEntity player, EntryScreen guiEntry) {
        long lastClock;
        if (mouseX > (double)(guiEntry.guiLeft + guiEntry.xSize) && (lastClock = System.currentTimeMillis() / 4L) != this.lastLinkClick) {
            this.lastLinkClick = lastClock;
            for (int i = 0; i < this.links.size(); ++i) {
                if (!GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)(guiEntry.guiLeft + guiEntry.xSize), (int)(guiEntry.guiTop + 10 + 20 * i), (int)this.links.get((int)i).width, (int)20)) continue;
                this.links.get(i).onClicked(book, category, entry, player, guiEntry.bookStack, guiEntry.pageNumber);
                return;
            }
        }
        this.page.onLeftClicked(book, category, entry, mouseX, mouseY, player, guiEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRightClicked(Book book, CategoryAbstract category, EntryAbstract entry, double mouseX, double mouseY, PlayerEntity player, EntryScreen guiEntry) {
        this.page.onRightClicked(book, category, entry, mouseX, mouseY, player, guiEntry);
    }

    private class EntryLink
    extends Link {
        private final EntryAbstract linkedEntry;

        private EntryLink(EntryAbstract entry) {
            this.linkedEntry = entry;
        }

        @Override
        public ITextComponent getDisplayName() {
            return this.linkedEntry.getName();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onClicked(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack, int page) {
            this.openLinkedEntry(book, category, this.linkedEntry, player, bookStack, entry, page);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void openLinkedEntry(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack, EntryAbstract from, int fromPage) {
            LinkedEntryScreen screen = new LinkedEntryScreen(book, category, entry, player, bookStack, from, fromPage);
            Minecraft.func_71410_x().func_147108_a((Screen)screen);
        }
    }

    public static class URLLink
    extends Link {
        private final ITextComponent name;
        private final URI link;

        public URLLink(ITextComponent name, URI link) {
            this.name = name;
            this.link = link;
        }

        @Override
        public ITextComponent getDisplayName() {
            return this.name;
        }

        @Override
        public void onClicked(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack, int page) {
            try {
                Class<?> oclass = Class.forName("java.awt.Desktop");
                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                oclass.getMethod("browse", URI.class).invoke(object, this.link);
            }
            catch (Throwable throwable1) {
                Throwable throwable = throwable1.getCause();
                LOGGER.error("Couldn't open link: {}", (Object)this.link);
                LOGGER.catching(throwable);
                player.func_146105_b(ForgeHooks.newChatWithLinks((String)("Couldn't open link: " + this.link.toString())), false);
            }
        }
    }

    private static abstract class Link {
        public int width;

        private Link() {
        }

        public abstract ITextComponent getDisplayName();

        @OnlyIn(value=Dist.CLIENT)
        public abstract void onClicked(Book var1, CategoryAbstract var2, EntryAbstract var3, PlayerEntity var4, ItemStack var5, int var6);
    }
}

