/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.lib.util.UtilLib;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public class PageTable
extends Page {
    private final List<String[]> lines;
    private final int[] width;
    private final ITextComponent headline;

    private PageTable(List<String[]> lines, int[] width, ITextComponent headline) {
        this.lines = lines;
        this.width = width;
        this.headline = headline;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        float charWidth = fontRendererObj.func_78256_a("W");
        int y = guiTop + 12;
        int x = guiLeft + 39;
        if (this.headline != null) {
            fontRendererObj.func_238421_b_(stack, "\u00a7l" + this.headline, (float)x, (float)y, 0);
            fontRendererObj.getClass();
            y += 9;
        }
        double d = x;
        fontRendererObj.getClass();
        double d2 = y + 9;
        double d3 = (float)x + (float)guiBase.xSize * 3.0f / 5.0f;
        fontRendererObj.getClass();
        this.drawLine(stack, d, d2, d3, y + 9, guiBase.publicZLevel);
        for (String[] l : this.lines) {
            x = guiLeft + 39;
            for (int i = 0; i < l.length; ++i) {
                int mw = (int)((float)this.width[i] * charWidth);
                int aw = fontRendererObj.func_78256_a(l[i]);
                int dw = (mw - aw) / 2;
                fontRendererObj.func_238421_b_(stack, l[i], (float)(x + dw), (float)y, 0);
                x += mw;
            }
            fontRendererObj.getClass();
            y += 9;
        }
    }

    protected void drawLine(MatrixStack stack, double x1, double y1, double x2, double y2, float publicZLevel) {
        stack.func_227860_a_();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        GL11.glDisable((int)3553);
        RenderSystem.lineWidth((float)2.0f);
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        builder.func_227888_a_(matrix, (float)x1, (float)y1, publicZLevel).func_225586_a_(0, 0, 0, 255).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, publicZLevel).func_225586_a_(0, 0, 0, 255).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEnable((int)3553);
        stack.func_227865_b_();
    }

    public static class Builder {
        int columns;
        List<String[]> lines;
        ITextComponent headline;

        public Builder(int columns) {
            this.columns = columns;
            this.lines = new ArrayList<String[]>();
        }

        public Builder addLine(Object ... objects) {
            if (objects.length != this.columns) {
                throw new IllegalArgumentException("Every added line as to contain one String for every column");
            }
            String[] l = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                l[i] = String.valueOf(objects[i]);
            }
            this.lines.add(l);
            return this;
        }

        public Builder addUnlocLine(String ... strings) {
            Object[] loc = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                loc[i] = UtilLib.translate(strings[i], new Object[0]);
            }
            return this.addLine(loc);
        }

        public PageTable build() {
            int[] width = new int[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                int max = 0;
                for (String[] s : this.lines) {
                    int w = s[i].length();
                    if (w <= max) continue;
                    max = w;
                }
                width[i] = max;
            }
            return new PageTable(this.lines, width, this.headline);
        }

        public Builder setHeadline(ITextComponent s) {
            this.headline = s;
            return this;
        }
    }
}

