/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class BloodValuePacket
implements IMessage {
    private final Pair<Map<ResourceLocation, Integer>, Integer>[] values;

    static void encode(BloodValuePacket msg, PacketBuffer buf) {
        for (Pair<Map<ResourceLocation, Integer>, Integer> e : msg.values) {
            buf.func_150787_b(((Map)e.getFirst()).size());
            for (Map.Entry f : ((Map)e.getFirst()).entrySet()) {
                buf.func_192572_a((ResourceLocation)f.getKey());
                buf.func_150787_b(((Integer)f.getValue()).intValue());
            }
            buf.func_150787_b(((Integer)e.getSecond()).intValue());
        }
    }

    static BloodValuePacket decode(PacketBuffer buf) {
        Pair[] values = (Pair[])Array.newInstance(Pair.class, 3);
        for (int i = 0; i < 3; ++i) {
            ConcurrentMap map = Maps.newConcurrentMap();
            int z = buf.func_150792_a();
            for (int u = 0; u < z; ++u) {
                map.put(buf.func_192575_l(), buf.func_150792_a());
            }
            values[i] = new Pair((Object)map, (Object)buf.func_150792_a());
        }
        return new BloodValuePacket(values);
    }

    public static void handle(BloodValuePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleBloodValuePacket(msg));
        ctx.setPacketHandled(true);
    }

    public BloodValuePacket(Pair<Map<ResourceLocation, Integer>, Integer>[] values) {
        this.values = values;
    }

    public Pair<Map<ResourceLocation, Integer>, Integer>[] getValues() {
        return this.values;
    }
}

