/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillNode {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SkillNode parent;
    private final List<SkillNode> children;
    private final ISkill[] elements;
    private final int depth;
    private final IPlayableFaction faction;
    private final ResourceLocation id;

    private SkillNode(ResourceLocation id, IPlayableFaction faction, SkillNode parent, int depth, ISkill ... elements) {
        this.id = id;
        this.parent = parent;
        this.faction = faction;
        this.depth = depth;
        this.children = new ArrayList<SkillNode>();
        this.elements = elements;
    }

    public SkillNode(IPlayableFaction faction, ISkill element) {
        this(faction.getID(), faction, null, 0, element);
    }

    public SkillNode(ResourceLocation id, SkillNode parent, ISkill ... elements) {
        this(id, parent.getFaction(), parent, parent.depth + 1, elements);
        parent.children.add(this);
    }

    public boolean containsSkill(ISkill skill) {
        return ArrayUtils.contains((Object[])this.elements, (Object)skill);
    }

    public List<SkillNode> getChildren() {
        return this.children;
    }

    public Builder getCopy() {
        return new Builder(this.parent.id, null, Arrays.asList(this.elements));
    }

    public int getDepth() {
        return this.depth;
    }

    public ISkill[] getElements() {
        return this.elements;
    }

    public IPlayableFaction getFaction() {
        return this.faction;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public SkillNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String toString() {
        return "SkillNode{faction=" + this.faction + ", depth=" + this.depth + ", elements=" + Arrays.toString(this.elements) + '}';
    }

    public static class Builder {
        public final ResourceLocation parentId;
        public final List<ISkill> skills;
        public final ResourceLocation mergeId;

        public static Builder deserialize(JsonObject json, JsonDeserializationContext context) {
            if (json.has("remove") && JSONUtils.func_151212_i((JsonObject)json, (String)"remove")) {
                return null;
            }
            ResourceLocation parent = json.has("parent") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"parent")) : null;
            ResourceLocation merge = json.has("merge") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"merge")) : null;
            JsonArray skills = JSONUtils.func_151213_a((JsonObject)json, (String)"skills", (JsonArray)new JsonArray());
            ArrayList<ISkill> skillList = new ArrayList<ISkill>();
            for (int i = 0; i < skills.size(); ++i) {
                ResourceLocation id = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)skills.get(i), (String)"skill"));
                ISkill s = (ISkill)ModRegistries.SKILLS.getValue(id);
                if (s == null) {
                    throw new IllegalArgumentException("Skill " + id + " is not registered");
                }
                skillList.add(s);
            }
            return new Builder(parent, merge, skillList);
        }

        public static Builder readFrom(PacketBuffer buf) {
            ResourceLocation parent = buf.readBoolean() ? buf.func_192575_l() : null;
            ResourceLocation merge = buf.readBoolean() ? buf.func_192575_l() : null;
            ArrayList<ISkill> skillList = new ArrayList<ISkill>();
            int count = buf.func_150792_a();
            for (int i = 0; i < count; ++i) {
                ResourceLocation id = buf.func_192575_l();
                ISkill s = (ISkill)ModRegistries.SKILLS.getValue(id);
                if (s == null) {
                    LOGGER.warn("Skill {} is not registered", (Object)id);
                }
                skillList.add(s);
            }
            return new Builder(parent, merge, skillList);
        }

        private Builder(ResourceLocation parentId, ResourceLocation mergeId, List<ISkill> skills) {
            this.mergeId = mergeId;
            this.parentId = parentId;
            this.skills = skills;
        }

        public boolean checkSkillFaction(IPlayableFaction faction) {
            for (ISkill s : this.skills) {
                if (faction.getID().equals((Object)s.getFaction().getID())) continue;
                return false;
            }
            return true;
        }

        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            if (this.parentId != null) {
                jsonobject.addProperty("parent", this.parentId.toString());
            } else if (this.mergeId != null) {
                jsonobject.addProperty("merge", this.mergeId.toString());
            }
            JsonArray skillIds = new JsonArray();
            for (ISkill s : this.skills) {
                skillIds.add(s.getRegistryName().toString());
            }
            jsonobject.add("skills", (JsonElement)skillIds);
            return jsonobject;
        }

        public String toString() {
            return "SkillNode.Builder{parent=" + this.parentId + ",merge=" + this.mergeId + "skills" + this.skills.toString() + "}";
        }

        public void writeTo(PacketBuffer buf) {
            if (this.parentId == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.func_192572_a(this.parentId);
            }
            if (this.mergeId == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.func_192572_a(this.mergeId);
            }
            buf.func_150787_b(this.skills.size());
            for (ISkill s : this.skills) {
                buf.func_192572_a(s.getRegistryName());
            }
        }
    }
}

