/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import java.util.UUID;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;

public class BatVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntitySize BAT_SIZE = EntitySize.func_220311_c((float)0.8f, (float)0.6f);
    public final UUID healthModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91429053c");
    private final float PLAYER_WIDTH = 0.6f;
    private final float PLAYER_HEIGHT = 1.8f;

    @Override
    public boolean activate(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        float oldMax = player.func_110138_aP();
        float oldHealth = player.func_110143_aJ();
        this.setModifier(player, true);
        float newMax = player.func_110138_aP();
        float mult = newMax / oldMax;
        float newHealth = mult * oldHealth;
        if (newHealth < 1.0f) {
            newHealth = 1.0f;
        }
        player.func_70606_j(newHealth);
        this.updatePlayer((VampirePlayer)vampire, true);
        if (player instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)player, VampireActionTrigger.Action.BAT);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.isGettingSundamage((IWorld)vampire.getRepresentingEntity().field_70170_p) && !((Object)((Object)ModItems.umbrella)).equals(vampire.getRepresentingEntity().func_184614_ca().func_77973_b()) && vampire.isGettingGarlicDamage((IWorld)vampire.getRepresentingEntity().field_70170_p) == EnumStrength.NONE && !vampire.getActionHandler().isActionActive(VampireActions.vampire_rage) && !vampire.getRepresentingPlayer().func_70090_H() && ((Boolean)VampirismConfig.SERVER.batModeInEnd.get() != false || vampire.getRepresentingPlayer().func_130014_f_().func_234922_V_() != DimensionType.field_236001_e_);
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.vaBatCooldown.get() * 20 + 1;
    }

    @Override
    public int getDuration(int level) {
        return MathHelper.func_76125_a((int)((Integer)VampirismConfig.BALANCE.vaBatDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaBatEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        float oldMax = player.func_110138_aP();
        float oldHealth = player.func_110143_aJ();
        this.setModifier(player, false);
        float newMax = player.func_110138_aP();
        float mult = newMax / oldMax;
        float newHealth = mult * oldHealth;
        player.func_70606_j(newHealth);
        if (!player.func_233570_aj_()) {
            player.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 100, false, false));
        }
        this.updatePlayer((VampirePlayer)vampire, false);
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
        this.setModifier(vampire.getRepresentingPlayer(), true);
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (vampire.isGettingSundamage((IWorld)vampire.getRepresentingEntity().field_70170_p) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_day"), Util.field_240973_b_);
            return true;
        }
        if (((Object)((Object)ModItems.umbrella)).equals(vampire.getRepresentingEntity().func_184614_ca().func_77973_b()) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_umbrella"), Util.field_240973_b_);
            return true;
        }
        if (vampire.isGettingGarlicDamage((IWorld)vampire.getRepresentingEntity().field_70170_p) != EnumStrength.NONE && !vampire.isRemote()) {
            vampire.getRepresentingEntity().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_garlic"), Util.field_240973_b_);
            return true;
        }
        if (!((Boolean)VampirismConfig.SERVER.batModeInEnd.get()).booleanValue() && vampire.getRepresentingPlayer().func_130014_f_().func_234922_V_() == DimensionType.field_236001_e_) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_end"), Util.field_240973_b_);
            return true;
        }
        return vampire.getRepresentingPlayer().func_70090_H();
    }

    private void setFlightSpeed(PlayerEntity player, float speed) {
        player.field_71075_bZ.field_75096_f = speed;
    }

    private void setModifier(PlayerEntity player, boolean enabled) {
        if (enabled) {
            ModifiableAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.MAX_HEALTH);
            if (health.func_111127_a(this.healthModifierUUID) == null) {
                health.func_233769_c_(new AttributeModifier(this.healthModifierUUID, "Bat Health Reduction", -((Double)VampirismConfig.BALANCE.vaBatHealthReduction.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = true;
            this.setFlightSpeed(player, 0.03f);
            player.func_71016_p();
        } else {
            ModifiableAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.MAX_HEALTH);
            AttributeModifier m = health.func_111127_a(this.healthModifierUUID);
            if (m != null) {
                health.func_111124_b(m);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
            }
            player.field_71075_bZ.field_75100_b = false;
            this.setFlightSpeed(player, 0.05f);
            player.func_71016_p();
        }
    }

    private void updatePlayer(VampirePlayer vampire, boolean bat) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        vampire.getSpecialAttributes().bat = bat;
        player.func_213323_x_();
        if (bat) {
            player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + (double)(1.8f - BatVampireAction.BAT_SIZE.field_220316_b), player.func_226281_cx_());
        }
    }
}

