/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionPropertyRandomizer;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodPotions {
    private static final Logger LOGGER = LogManager.getLogger(BloodPotions.class);

    public static void register() {
        IBloodPotionRegistry registry = VampirismAPI.bloodPotionRegistry();
        registry.registerPotionEffect(new ResourceLocation("vampirism", "speed"), IBloodPotionRegistry.CATEGORY_NORMAL_BODY_BOOSTS, false, Effects.field_76424_c, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "jump"), IBloodPotionRegistry.CATEGORY_NORMAL_BODY_BOOSTS, false, Effects.field_76430_j, 25, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 5000, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "health"), IBloodPotionRegistry.CATEGORY_NORMAL_BODY_BOOSTS, false, Effects.field_180152_w, 25, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 5000, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "resistance"), IBloodPotionRegistry.CATEGORY_NORMAL_BODY_BOOSTS, false, Effects.field_76429_m, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        registry.addItemsToCategory(false, IBloodPotionRegistry.CATEGORY_NORMAL_BODY_BOOSTS, Items.field_151034_e, Items.field_151083_be, Items.field_151157_am, Items.field_151168_bH, Items.field_151025_P);
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_speed"), IBloodPotionRegistry.CATEGORY_SPECIAL_BODY_BOOSTS, false, Effects.field_76424_c, 15, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1500, 2));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_jump"), IBloodPotionRegistry.CATEGORY_SPECIAL_BODY_BOOSTS, false, Effects.field_76430_j, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(400, 1000, 2));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_health"), IBloodPotionRegistry.CATEGORY_SPECIAL_BODY_BOOSTS, false, Effects.field_180152_w, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(400, 1000, 2));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_resistance"), IBloodPotionRegistry.CATEGORY_SPECIAL_BODY_BOOSTS, false, Effects.field_76429_m, 15, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1500, 2));
        registry.addItemsToCategory(false, IBloodPotionRegistry.CATEGORY_SPECIAL_BODY_BOOSTS, Items.field_151153_ao, Items.field_151150_bK);
        registry.registerPotionEffect(new ResourceLocation("vampirism", "night_vision"), IBloodPotionRegistry.CATEGORY_NORMAL_VAMPIRE_SKILLS, false, Effects.field_76439_r, 20, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        registry.addItemsToCategory(false, IBloodPotionRegistry.CATEGORY_NORMAL_VAMPIRE_SKILLS, ModItems.vampire_fang, ModItems.blood_bottle, ModBlocks.coffin.func_199767_j());
        registry.registerPotionEffect(new ResourceLocation("vampirism", "disguise"), IBloodPotionRegistry.CATEGORY_SPECIAL_VAMPIRE_SKILL, false, ModEffects.disguise_as_vampire, 5, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1500, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_night_vision"), IBloodPotionRegistry.CATEGORY_SPECIAL_VAMPIRE_SKILL, false, Effects.field_76439_r, 20, new IBloodPotionPropertyRandomizer.SimpleRandomizer(1000, 24000, 0));
        registry.addItemsToCategory(false, IBloodPotionRegistry.CATEGORY_SPECIAL_VAMPIRE_SKILL, ModItems.pure_blood_0, ModItems.pure_blood_1, ModItems.pure_blood_2, ModItems.pure_blood_3, ModItems.pure_blood_4);
        registry.registerPotionEffect(new ResourceLocation("vampirism", "invisibility"), IBloodPotionRegistry.CATEGORY_SPECIAL_OTHERS, false, Effects.field_76441_p, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 0));
        registry.addItemsToCategory(false, IBloodPotionRegistry.CATEGORY_SPECIAL_OTHERS, Items.field_151045_i);
        registry.registerPotionEffect(new ResourceLocation("vampirism", "weakness"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76437_t, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 6000, 1));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "short_nausea"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76431_k, 20, new IBloodPotionPropertyRandomizer.SimpleRandomizer(300, 700, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "slowness"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76421_d, 30, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 5000, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "hunger"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76438_s, 25, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 5000, 0));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_weakness"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76437_t, 15, new IBloodPotionPropertyRandomizer.SimpleRandomizer(600, 1500, 2));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "special_slowness"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76421_d, 10, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1000, 2));
        registry.registerPotionEffect(new ResourceLocation("vampirism", "long_nausea"), IBloodPotionRegistry.CATEGORY_OTHERS, true, Effects.field_76431_k, 2, new IBloodPotionPropertyRandomizer.SimpleRandomizer(500, 1000, 2));
    }

    public static void addTooltip(ItemStack stack, List<ITextComponent> tooltip, IHunterPlayer player) {
        ISkillHandler skillHandler = player.getSkillHandler();
        ArrayList effects = stack.func_77942_o() ? BloodPotions.readEffectsFromNBT(stack.func_77978_p()) : Lists.newArrayList();
        Random identifyRandom = null;
        if (skillHandler.isSkillEnabled(HunterSkills.blood_potion_identify_some)) {
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            int seed = nbt.func_74764_b("ident_seed") ? nbt.func_74762_e("ident_seed") : stack.hashCode();
            identifyRandom = new Random(seed);
        }
        for (ConfiguredEffect effect : effects) {
            Object text = identifyRandom != null && identifyRandom.nextBoolean() ? effect.getEffect().getLocName(effect.properties) : new TranslationTextComponent("text.vampirism.unknown");
            if (skillHandler.isSkillEnabled(HunterSkills.blood_potion_good_or_bad) && text instanceof IFormattableTextComponent) {
                text = effect.getEffect().isBad() ? ((IFormattableTextComponent)text).func_240699_a_(TextFormatting.DARK_RED) : ((IFormattableTextComponent)text).func_240699_a_(TextFormatting.DARK_GREEN);
            }
            tooltip.add((ITextComponent)text);
        }
    }

    public static void applyEffects(ItemStack stack, LivingEntity entity) {
        HunterPlayer hunterPlayer;
        if (!stack.func_77942_o()) {
            return;
        }
        List<ConfiguredEffect> effects = BloodPotions.readEffectsFromNBT(stack.func_77978_p());
        boolean flag = entity instanceof IHunterMob;
        float durationMult = 1.0f;
        if (!flag && entity instanceof PlayerEntity && entity.func_70089_S() && (hunterPlayer = HunterPlayer.get((PlayerEntity)entity)).getLevel() > 0) {
            flag = true;
            if (hunterPlayer.getSkillHandler().isSkillEnabled(HunterSkills.blood_potion_duration)) {
                durationMult = (float)((double)durationMult + 0.3);
            }
        }
        if (flag) {
            for (ConfiguredEffect effect : effects) {
                effect.getEffect().onActivated(entity, effect.getProperties(), durationMult);
            }
        }
    }

    @Nonnull
    private static List<ConfiguredEffect> readEffectsFromNBT(CompoundNBT nbt) {
        ArrayList effects = Lists.newArrayList();
        CompoundNBT effectsTag = nbt.func_74775_l("effects");
        for (String id : effectsTag.func_150296_c()) {
            CompoundNBT properties = effectsTag.func_74775_l(id);
            IBloodPotionEffect effect = VampirismAPI.bloodPotionRegistry().getEffectFromId(new ResourceLocation(id));
            if (effect == null) {
                LOGGER.warn("Cannot find effect with id %s", (Object)id);
                continue;
            }
            effects.add(new ConfiguredEffect(effect, properties));
        }
        return effects;
    }

    public static void chooseAndAddEffects(@Nonnull ItemStack stack, @Nonnull IHunterPlayer crafter, @Nullable ItemStack extraItem) {
        ArrayList effects = Lists.newArrayList();
        IBloodPotionRegistry registry = VampirismAPI.bloodPotionRegistry();
        Random rnd = crafter.getRepresentingPlayer().func_70681_au();
        ISkillHandler skillHandler = crafter.getSkillHandler();
        int good = rnd.nextInt(2) + 1;
        if (rnd.nextInt(10) == 0) {
            good = 3;
        }
        int badReductions = 0;
        if (skillHandler.isSkillEnabled(HunterSkills.blood_potion_less_bad)) {
            ++badReductions;
        }
        if (skillHandler.isSkillEnabled(HunterSkills.blood_potion_less_bad_2)) {
            ++badReductions;
        }
        int bad = badReductions == 1 ? (rnd.nextInt(10) == 0 ? 2 : 1) : (badReductions == 2 ? rnd.nextInt(2) : (rnd.nextInt(10) == 0 ? 3 : rnd.nextInt(2) + 1));
        int extra = 0;
        for (int i = 0; i < good + bad + extra; ++i) {
            IBloodPotionEffect effect = registry.getRandomEffect(extraItem, i >= good + extra, rnd);
            boolean valid = true;
            for (ConfiguredEffect effect1 : effects) {
                if (effect1.getEffect().canCoexist(effect)) continue;
                extra = Math.min(extra + 1, 5);
                valid = false;
            }
            if (!valid) continue;
            effects.add(new ConfiguredEffect(effect, effect.getRandomProperties(rnd)));
        }
        BloodPotions.addEffects(stack, effects);
    }

    private static void addEffects(ItemStack stack, List<ConfiguredEffect> effects) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT effectTag = new CompoundNBT();
        for (ConfiguredEffect effect : effects) {
            effectTag.func_218657_a(effect.getEffect().getId().toString(), (INBT)effect.getProperties());
        }
        nbt.func_218657_a("effects", (INBT)effectTag);
        if (!nbt.func_74764_b("ident_seed")) {
            int seed = stack.hashCode();
            nbt.func_74768_a("ident_seed", seed);
        }
        stack.func_77982_d(nbt);
    }

    @Nonnull
    public static List<ITextComponent> getLocalizedCategoryHint(ItemStack extra) {
        IBloodPotionRegistry registry = VampirismAPI.bloodPotionRegistry();
        return registry.getLocCategoryDescForItem(extra);
    }

    private static class ConfiguredEffect {
        private final IBloodPotionEffect effect;
        private final CompoundNBT properties;

        private ConfiguredEffect(IBloodPotionEffect effect, CompoundNBT properties) {
            this.effect = effect;
            this.properties = properties;
        }

        public IBloodPotionEffect getEffect() {
            return this.effect;
        }

        public CompoundNBT getProperties() {
            return this.properties;
        }

        public String toString() {
            return "ConfEffect{effect=" + this.effect + ", properties=" + this.properties + '}';
        }
    }
}

