/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class RandomStructureProcessor
extends RuleStructureProcessor {
    public static final Codec<RandomStructureProcessor> CODEC = RandomBlockState.CODEC.listOf().fieldOf("rules").xmap(RandomStructureProcessor::new, rule -> rule.rules).codec();
    private final ImmutableList<RandomBlockState> rules;

    public RandomStructureProcessor(List<RandomBlockState> rules) {
        super(Collections.emptyList());
        this.rules = ImmutableList.copyOf(rules);
    }

    @Nullable
    public Template.BlockInfo process(IWorldReader worldReaderIn, @Nonnull BlockPos pos, @Nonnull BlockPos pos2, @Nonnull Template.BlockInfo blockInfo, Template.BlockInfo blockInfo1, @Nonnull PlacementSettings placementSettings, @Nullable Template template) {
        Random random = new Random(MathHelper.func_180186_a((Vector3i)blockInfo1.field_186242_a));
        BlockState blockstate = worldReaderIn.func_180495_p(blockInfo1.field_186242_a);
        for (RandomBlockState ruleEntry : this.rules) {
            if (!ruleEntry.func_237110_a_(blockInfo1.field_186243_b, blockstate, blockInfo.field_186242_a, blockInfo1.field_186242_a, pos2, random)) continue;
            Pair<BlockState, CompoundNBT> pair = ruleEntry.getOutput();
            return new Template.BlockInfo(blockInfo1.field_186242_a, (BlockState)pair.getFirst(), (CompoundNBT)pair.getSecond());
        }
        return blockInfo1;
    }

    @Nonnull
    protected IStructureProcessorType<?> func_215192_a() {
        return ModFeatures.random_selector;
    }
}

