/*
 * Decompiled with CFR 0.152.
 */
package lykrast.voyage;

import java.util.Objects;
import lykrast.voyage.config.ConfigManager;
import lykrast.voyage.init.VoyageBiomes;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import noobanidus.libs.repack_voyage.noobutil.config.BiomeConfig;
import noobanidus.libs.repack_voyage.noobutil.world.gen.ColorConstants;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VoyageRegistry {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        VoyageRegistry.register(VoyageBiomes.MOUNT, ConfigManager.MOUNT, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD);
        VoyageRegistry.register(VoyageBiomes.BOG, ConfigManager.BOG, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        VoyageRegistry.register(VoyageBiomes.LAGOON_WARM, ConfigManager.LAGOON_WARM, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT);
        VoyageRegistry.register(VoyageBiomes.LAGOON_LUKEWARM, ConfigManager.LAGOON_LUKEWARM, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET);
        VoyageRegistry.register(VoyageBiomes.LAGOON_COLD, ConfigManager.LAGOON_COLD, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.COLD);
        VoyageRegistry.register(VoyageBiomes.STEPPE, ConfigManager.STEPPE, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageRegistry.register(VoyageBiomes.ROCKY_PEAKS, ConfigManager.ROCKY_PEAKS, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN);
        VoyageRegistry.register(VoyageBiomes.DESERT_MIXED, ConfigManager.DESERT_MIXED, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageRegistry.register(VoyageBiomes.DESERT_MIXED_HILLS, ConfigManager.DESERT_MIXED_HILLS, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageRegistry.register(VoyageBiomes.FLOWER_PLAINS, ConfigManager.FLOWER_PLAINS, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS);
        VoyageRegistry.register(VoyageBiomes.DESERT_MOUNTAINS, ConfigManager.DESERT_MOUNTAINS, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageRegistry.register(VoyageBiomes.DESERT_POLAR, ConfigManager.DESERT_POLAR, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        VoyageRegistry.register(VoyageBiomes.FOREST_LUSH, ConfigManager.FOREST_LUSH, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        VoyageRegistry.register(VoyageBiomes.ROCK_FIELD, ConfigManager.ROCK_FIELD, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DRY);
    }

    private static void register(Biome b, BiomeConfig config, BiomeManager.BiomeType managerType, BiomeDictionary.Type ... dictTypes) {
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(b.getRegistryName()));
        if (config.shouldSpawn()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)managerType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, config.weight()));
            BiomeDictionary.addTypes((RegistryKey)biome, (BiomeDictionary.Type[])dictTypes);
        }
    }

    public static BiomeAmbience.Builder createDefaultBiomeAmbience() {
        return new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_242539_d(ColorConstants.getSkyColor(0.2f)).func_235239_a_(12638463);
    }
}

