/*
 * Decompiled with CFR 0.152.
 */
package lykrast.voyage.init;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import lykrast.voyage.Voyage;
import lykrast.voyage.biomes.BogBiome;
import lykrast.voyage.biomes.DesertBiome;
import lykrast.voyage.biomes.DesertPolarBiome;
import lykrast.voyage.biomes.FlowerPlainsBiome;
import lykrast.voyage.biomes.ForestLushBiome;
import lykrast.voyage.biomes.LagoonBiome;
import lykrast.voyage.biomes.MountBiome;
import lykrast.voyage.biomes.RockFieldBiome;
import lykrast.voyage.biomes.RockyPeaksBiome;
import lykrast.voyage.biomes.SteppeBiome;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="voyage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VoyageBiomes {
    private static Set<Biome> BIOMES = new HashSet<Biome>();
    public static Biome MOUNT = VoyageBiomes.register("mount", () -> MountBiome.MOUNT);
    public static Biome BOG = VoyageBiomes.register("bog", () -> BogBiome.BOG_BIOME);
    public static Biome LAGOON_WARM = VoyageBiomes.register("lagoon_warm", () -> LagoonBiome.LAGOON_WARM);
    public static Biome LAGOON_LUKEWARM = VoyageBiomes.register("lagoon_lukewarm", () -> LagoonBiome.LAGOON_LUKEWARM);
    public static Biome LAGOON_COLD = VoyageBiomes.register("lagoon_cold", () -> LagoonBiome.LAGOON_COLD);
    public static Biome STEPPE = VoyageBiomes.register("steppe", () -> SteppeBiome.STEPPE);
    public static Biome ROCKY_PEAKS = VoyageBiomes.register("rocky_peaks", () -> RockyPeaksBiome.ROCKY_PEAKS);
    public static Biome DESERT_MIXED = VoyageBiomes.register("desert_mixed", () -> DesertBiome.DESERT_MIXED);
    public static Biome DESERT_MIXED_HILLS = VoyageBiomes.register("desert_mixed_hills", () -> DesertBiome.DESERT_MIXED_HILLS);
    public static Biome FLOWER_PLAINS = VoyageBiomes.register("flower_plains", () -> FlowerPlainsBiome.FLOWER_PLAINS);
    public static Biome DESERT_MOUNTAINS = VoyageBiomes.register("desert_mountains", () -> DesertBiome.DESERT_MOUNTAINS);
    public static Biome DESERT_POLAR = VoyageBiomes.register("desert_polar", () -> DesertPolarBiome.DESERT_POLAR);
    public static Biome FOREST_LUSH = VoyageBiomes.register("forest_lush", () -> ForestLushBiome.FOREST_LUSH);
    public static Biome ROCK_FIELD = VoyageBiomes.register("rock_field", () -> RockFieldBiome.ROCK_FIELD);

    private static Biome register(String name, Supplier<Biome> builder) {
        ResourceLocation rl = Voyage.loc(name);
        Biome biome = builder.get();
        biome.setRegistryName(rl);
        BIOMES.add(biome);
        return biome;
    }

    @SubscribeEvent
    public static void eventRegister(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BIOMES.toArray(new Biome[0]));
    }
}

