/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_voyage.noobutil.config;

import java.util.Collection;
import net.minecraftforge.common.ForgeConfigSpec;

public class BiomeConfig {
    private String name;
    private int weight;
    private ForgeConfigSpec.IntValue configWeight;

    private BiomeConfig(String name, int weight, Collection<BiomeConfig> list) {
        this.name = name;
        this.weight = weight;
        list.add(this);
    }

    public String name() {
        return this.name;
    }

    public int weight() {
        return (Integer)this.configWeight.get();
    }

    public boolean shouldSpawn() {
        return this.weight() > 0;
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " biome generation").push(this.name + "_biome");
        this.configWeight = builder.comment("spawn weight of the biome (0 to disable generation)").defineInRange("weight", this.weight, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static class Builder {
        private final Collection<BiomeConfig> list;

        public Builder(Collection<BiomeConfig> list) {
            this.list = list;
        }

        public BiomeConfig build(String name, int weight) {
            return new BiomeConfig(name, weight, this.list);
        }
    }
}

