/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_voyage.noobutil.material;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import noobanidus.libs.repack_voyage.noobutil.item.WeaponType;

public class MaterialType {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final UUID MAIN_HAND_MODIFIER = UUID.fromString("0e2c39ce-5247-4095-abf7-d99bd7387a95");
    public static final UUID OFF_HAND_MODIFIER = UUID.fromString("28ad5d13-618f-4c80-8f60-0e0469c1a046");
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private final String name;
    private IItemTier tier = null;
    private IArmorMaterial material = null;
    private int maxUses;
    private float efficiency;
    private float attackDamage;
    private int harvestLevel;
    private int enchantability;
    private float knockbackResistance;
    private Supplier<Ingredient> repairMaterial;
    private int maxDamageFactor;
    private int[] damageReductionAmountArray;
    private SoundEvent soundEvent;
    private float toughness;
    private Supplier<Supplier<? extends Item>> item;
    private Supplier<Supplier<? extends Item>> dust;
    private Supplier<Supplier<? extends Item>> nugget;
    private Supplier<Supplier<? extends Block>> block;
    private Supplier<Supplier<? extends Block>> ore;
    private int maxXP = 0;
    private int minXP = 0;
    private String modId;
    private Object2FloatOpenHashMap<WeaponType> damage = new Object2FloatOpenHashMap();
    private Object2FloatOpenHashMap<WeaponType> speed = new Object2FloatOpenHashMap();
    private List<WeaponType> itemTypes;
    private ArmorMaterial armorMaterial = new ArmorMaterial();
    private ItemMaterial itemMaterial = new ItemMaterial();

    public MaterialType(String name) {
        this.name = name;
        this.putDamageSpeed(new Object[]{WeaponType.SWORD, Float.valueOf(3.0f), Float.valueOf(-2.4f), WeaponType.SHOVEL, Float.valueOf(1.5f), Float.valueOf(-3.0f), WeaponType.PICKAXE, Float.valueOf(1.0f), Float.valueOf(-2.8f), WeaponType.HOE, Float.valueOf(1.0f), Float.valueOf(-1.0f)});
    }

    public ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    public ItemMaterial getItemMaterial() {
        return this.itemMaterial;
    }

    public MaterialType setModId(String modId) {
        this.modId = modId;
        return this;
    }

    public String getModId() {
        return this.modId;
    }

    public MaterialType itemMaterial(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability) {
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.harvestLevel = harvestLevel;
        this.enchantability = enchantability;
        this.repairMaterial = () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)this.item.get().get()});
        return this;
    }

    public MaterialType itemMaterial(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<Ingredient> repairMaterial) {
        return this.itemMaterial(maxUses, efficiency, attackDamage, harvestLevel, enchantability);
    }

    public MaterialType armorMaterial(int maxDamageFactor, int[] damageReductionAmountArray, SoundEvent soundEvent, float toughness, float knockbackResistance) {
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmountArray;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        return this;
    }

    public MaterialType setItemTier(IItemTier tier) {
        this.tier = tier;
        return this;
    }

    public MaterialType setArmorMaterial(IArmorMaterial material) {
        this.material = material;
        return this;
    }

    public int getMaxXP() {
        return this.maxXP;
    }

    public MaterialType setMaxXP(int maxXP) {
        this.maxXP = maxXP;
        return this;
    }

    public int getMinXP() {
        return this.minXP;
    }

    public MaterialType setMinXP(int minXP) {
        this.minXP = minXP;
        return this;
    }

    public MaterialType putDamageSpeed(Object ... entries) {
        if (entries.length % 3 != 0) {
            throw new IllegalArgumentException("Invalid number of arguments to putDamageSpeed");
        }
        for (int i = 0; i < entries.length; i += 3) {
            WeaponType type = (WeaponType)((Object)entries[i]);
            float damage = ((Float)entries[i + 1]).floatValue();
            float speed = ((Float)entries[i + 2]).floatValue();
            this.damage.put((Object)type, damage);
            this.speed.put((Object)type, speed);
        }
        return this;
    }

    public int getDamage(WeaponType type) {
        return (int)this.damage.getOrDefault((Object)type, 1.0f);
    }

    public int getDamage(String type) {
        return this.getDamage(WeaponType.byName(type));
    }

    public float getSpeed(WeaponType type) {
        return this.speed.getOrDefault((Object)type, -1.0f);
    }

    public float getSpeed(String type) {
        return this.getSpeed(WeaponType.byName(type));
    }

    public List<WeaponType> getItemTypes() {
        return this.itemTypes;
    }

    public MaterialType setItemTypes(WeaponType ... types) {
        this.itemTypes = Arrays.asList(types);
        return this;
    }

    public String getInternalName() {
        return this.name;
    }

    public String getIngotName() {
        return this.name + "_ingot";
    }

    public Supplier<? extends Item> getItem() {
        return this.item.get();
    }

    public Supplier<? extends Item> getDust() {
        return this.dust.get();
    }

    public Supplier<? extends Item> getNugget() {
        return this.nugget.get();
    }

    public Supplier<? extends Block> getBlock() {
        return this.block.get();
    }

    public Supplier<? extends Block> getOre() {
        return this.ore.get();
    }

    public MaterialType item(Supplier<Supplier<? extends Item>> ingot) {
        this.item = ingot;
        return this;
    }

    public MaterialType dust(Supplier<Supplier<? extends Item>> dust) {
        this.dust = dust;
        return this;
    }

    public MaterialType nugget(Supplier<Supplier<? extends Item>> nugget) {
        this.nugget = nugget;
        return this;
    }

    public MaterialType block(Supplier<Supplier<? extends Block>> block) {
        this.block = block;
        return this;
    }

    public MaterialType ore(Supplier<Supplier<? extends Block>> ore) {
        this.ore = ore;
        return this;
    }

    public AbstractBlock.Properties getBlockProps(AbstractBlock.Properties props) {
        return props.func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(1);
    }

    public Supplier<AbstractBlock.Properties> getBlockProps() {
        return () -> this.getBlockProps(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f));
    }

    public AbstractBlock.Properties getOreBlockProperties(AbstractBlock.Properties props) {
        return props.func_200948_a(3.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(this.getHarvestLevel() - 1);
    }

    public Supplier<AbstractBlock.Properties> getOreBlockProperties() {
        return () -> this.getOreBlockProperties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e));
    }

    public int getHarvestLevel() {
        return this.tier == null ? this.harvestLevel : this.tier.func_200925_d();
    }

    public String gemName() {
        return this.name + "_gem";
    }

    public String ingotName() {
        return this.name + "_ingot";
    }

    public String dustName() {
        return this.name + "_dust";
    }

    public String blockName() {
        return this.name + "_block";
    }

    public String oreName() {
        return this.name + "_ore";
    }

    public String nuggetName() {
        return this.name + "_nugget";
    }

    public class ItemMaterial
    implements IItemTier {
        public int func_200926_a() {
            return MaterialType.this.tier == null ? MaterialType.this.maxUses : MaterialType.this.tier.func_200926_a();
        }

        public float func_200928_b() {
            return MaterialType.this.tier == null ? MaterialType.this.efficiency : MaterialType.this.tier.func_200928_b();
        }

        public float func_200929_c() {
            return MaterialType.this.tier == null ? MaterialType.this.attackDamage : MaterialType.this.tier.func_200929_c();
        }

        public int func_200925_d() {
            return MaterialType.this.getHarvestLevel();
        }

        public int func_200927_e() {
            return MaterialType.this.tier == null ? MaterialType.this.enchantability : MaterialType.this.tier.func_200927_e();
        }

        @Nonnull
        public Ingredient func_200924_f() {
            return MaterialType.this.tier == null ? (Ingredient)MaterialType.this.repairMaterial.get() : MaterialType.this.tier.func_200924_f();
        }
    }

    public class ArmorMaterial
    implements IArmorMaterial {
        public int func_200896_a(EquipmentSlotType slotIn) {
            return MaterialType.this.material == null ? MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * MaterialType.this.maxDamageFactor : MaterialType.this.material.func_200896_a(slotIn);
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return MaterialType.this.material == null ? MaterialType.this.damageReductionAmountArray[slotIn.func_188454_b()] : MaterialType.this.material.func_200902_b(slotIn);
        }

        public SoundEvent func_200899_b() {
            return MaterialType.this.material == null ? MaterialType.this.soundEvent : MaterialType.this.material.func_200899_b();
        }

        public float func_200901_e() {
            return MaterialType.this.material == null ? MaterialType.this.toughness : MaterialType.this.material.func_200901_e();
        }

        public float func_230304_f_() {
            return MaterialType.this.material == null ? MaterialType.this.knockbackResistance : MaterialType.this.material.func_230304_f_();
        }

        @Nonnull
        public Ingredient func_200898_c() {
            return MaterialType.this.tier == null ? (Ingredient)MaterialType.this.repairMaterial.get() : MaterialType.this.tier.func_200924_f();
        }

        public int func_200900_a() {
            return MaterialType.this.tier == null ? MaterialType.this.enchantability : MaterialType.this.tier.func_200927_e();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_200897_d() {
            return MaterialType.this.getModId() + ":" + MaterialType.this.getInternalName();
        }
    }
}

