/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_voyage.noobutil.mixin;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.ShoreLayer;
import net.minecraftforge.common.BiomeDictionary;
import noobanidus.libs.repack_voyage.noobutil.world.gen.BiomeReference;
import noobanidus.libs.repack_voyage.noobutil.world.gen.BiomeVariants;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShoreLayer.class})
public class MixinShoreLayer {
    @Inject(at={@At(value="HEAD")}, method={"apply(Lnet/minecraft/world/gen/INoiseRandom;IIIII)I"}, cancellable=true)
    private void apply(INoiseRandom context, int north, int west, int south, int east, int center, CallbackInfoReturnable<Integer> info) {
        RegistryKey key = BiomeRegistry.func_244203_a((int)center);
        RegistryKey<Biome> shoreKey = BiomeVariants.pickReplacement((RegistryKey<Biome>)key, BiomeVariants.VariantType.SHORE);
        if (shoreKey != null && MixinShoreLayer.neighboursOcean(north, east, south, west)) {
            info.setReturnValue((Object)BiomeReference.getBiomeID(shoreKey));
            return;
        }
        RegistryKey<Biome> edgeKey = BiomeVariants.pickReplacement((RegistryKey<Biome>)key, BiomeVariants.VariantType.EDGE);
        if (edgeKey != null && MixinShoreLayer.isEdge(north, east, south, west, center)) {
            info.setReturnValue((Object)BiomeReference.getBiomeID(edgeKey));
        }
    }

    private static boolean neighboursOcean(int north, int east, int south, int west) {
        return MixinShoreLayer.isOceanBiome(north) || MixinShoreLayer.isOceanBiome(east) || MixinShoreLayer.isOceanBiome(south) || MixinShoreLayer.isOceanBiome(west);
    }

    private static boolean isOceanBiome(int id) {
        RegistryKey key = BiomeRegistry.func_244203_a((int)id);
        return BiomeDictionary.getTypes((RegistryKey)key).contains(BiomeDictionary.Type.OCEAN);
    }

    private static boolean isEdge(int north, int east, int south, int west, int center) {
        return MixinShoreLayer.areDissimilar(center, north) || MixinShoreLayer.areDissimilar(center, east) || MixinShoreLayer.areDissimilar(center, south) || MixinShoreLayer.areDissimilar(center, west);
    }

    private static boolean areDissimilar(int mainBiomeId, int secondaryBiomeId) {
        if (mainBiomeId == secondaryBiomeId) {
            return false;
        }
        Int2IntMap parentChildMap = HillsLayer.field_242940_c;
        return parentChildMap.get(mainBiomeId) != secondaryBiomeId && parentChildMap.get(secondaryBiomeId) != mainBiomeId;
    }
}

