/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_voyage.noobutil.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class PacketHandler {
    private final String PROTOCOL_VERSION = Integer.toString(2);
    private short index = 0;
    public final SimpleChannel HANDLER;
    private int id = 0;

    public PacketHandler(String modid) {
        this.HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, "main_network_channel")).clientAcceptedVersions(this.PROTOCOL_VERSION::equals).serverAcceptedVersions(this.PROTOCOL_VERSION::equals).networkProtocolVersion(() -> this.PROTOCOL_VERSION).simpleChannel();
    }

    public abstract void registerMessages();

    public void sendToInternal(Object msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            this.HANDLER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void sendToServerInternal(Object msg) {
        this.HANDLER.sendToServer(msg);
    }

    public <MSG> void sendInternal(PacketDistributor.PacketTarget target, MSG message) {
        this.HANDLER.send(target, message);
    }

    public <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.HANDLER.registerMessage((int)this.index, messageType, encoder, decoder, messageConsumer);
        this.index = (short)(this.index + 1);
        if (this.index > 255) {
            throw new RuntimeException("Too many messages!");
        }
    }
}

