/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_voyage.noobutil.world.gen.placer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import noobanidus.libs.repack_voyage.noobutil.types.LazyStateSupplier;

public abstract class AbstractColumnBasePlacer
extends BlockPlacer {
    protected final int minSize;
    protected final int extraSize;
    protected final int radius1;
    protected final int radius2;
    protected final Set<LazyStateSupplier> replace;
    protected final int peak;

    public static <T extends AbstractColumnBasePlacer> Codec<T> codecBuilder(Builder<T> abstractBuilder) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("min_size").forGetter(o -> o.minSize), (App)Codec.INT.fieldOf("extra_size").forGetter(o -> o.extraSize), (App)Codec.INT.fieldOf("radius1").forGetter(o -> o.radius1), (App)Codec.INT.fieldOf("radius2").forGetter(o -> o.radius2), (App)LazyStateSupplier.CODEC.listOf().fieldOf("replacements").forGetter(o -> ImmutableList.copyOf(o.replace)), (App)Codec.INT.fieldOf("peak").forGetter(o -> o.peak)).apply((Applicative)builder, abstractBuilder::create));
    }

    public AbstractColumnBasePlacer(int minSize, int extraSize, int radius1, int radius2, List<LazyStateSupplier> replace, int peak) {
        this.minSize = minSize;
        this.extraSize = extraSize;
        this.radius1 = radius1;
        this.radius2 = radius2;
        this.replace = ImmutableSet.copyOf(replace);
        this.peak = peak;
    }

    protected abstract BlockPlacerType<?> func_230368_a_();

    public void func_225567_a_(IWorld world, BlockPos pos, BlockState state, Random random) {
        int i = this.radius1 + random.nextInt(this.radius2);
        for (int j = pos.func_177958_n() - i; j <= pos.func_177958_n() + i; ++j) {
            block1: for (int k = pos.func_177952_p() - i; k <= pos.func_177952_p() + i; ++k) {
                int i1;
                int l = j - pos.func_177958_n();
                if (l * l + (i1 = k - pos.func_177952_p()) * i1 > i * i) continue;
                int j1 = pos.func_177956_o() - 1;
                BlockPos blockpos = new BlockPos(j, j1, k);
                Block block = world.func_180495_p(blockpos).func_177230_c();
                for (LazyStateSupplier blockstate : this.replace) {
                    if (!((BlockState)blockstate.get()).func_203425_a(block)) continue;
                    world.func_180501_a(blockpos, state, 2);
                    if (random.nextInt(this.peak) != 0) continue block1;
                    world.func_180501_a(blockpos.func_177984_a(), state, 2);
                    if (random.nextInt(Math.max(1, this.peak / 2)) != 0) continue block1;
                    world.func_180501_a(blockpos.func_177984_a().func_177984_a(), state, 2);
                    if (random.nextInt(Math.max(1, this.peak / 3)) != 0) continue block1;
                    world.func_180501_a(blockpos.func_177984_a().func_177984_a().func_177984_a(), state, 2);
                    continue block1;
                }
            }
        }
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        i = this.minSize + random.nextInt(random.nextInt(this.extraSize + 1) + 1);
        for (int j = 0; j < i; ++j) {
            world.func_180501_a((BlockPos)blockpos$mutable, state, 2);
            blockpos$mutable.func_189536_c(Direction.UP);
        }
    }

    public static interface Builder<T extends AbstractColumnBasePlacer> {
        public T create(int var1, int var2, int var3, int var4, List<LazyStateSupplier> var5, int var6);
    }
}

