/*
 * Decompiled with CFR 0.152.
 */
package com.tyon2006.whereAmIGoing;

import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;
    private static String file;

    public static void init() {
        config = new Configuration(new File(file));
        try {
            config.load();
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    public static void removeConfig(String category) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.hasCategory(category)) {
                config.removeCategory(new ConfigCategory(category));
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    public static void removeConfig(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                config.getCategory(category).remove((Object)key);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    public static int getInt(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                int n = config.get(category, key, 0).getInt();
                return n;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getDouble(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                double d = config.get(category, key, 0.0).getDouble();
                return d;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return 0.0;
    }

    public static float getFloat(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                float f = (float)config.get(category, key, 0.0).getDouble();
                return f;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return 0.0f;
    }

    public static String getString(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                String string = config.get(category, key, "").getString();
                return string;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLong(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                long l = config.get(category, key, 0.0).getLong();
                return l;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return 0L;
    }

    public static short getShort(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                short s = (short)config.get(category, key, 0).getInt();
                return s;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return 0;
    }

    public static byte getByte(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                byte by = (byte)config.get(category, key, 0).getInt();
                return by;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return 0;
    }

    public static boolean getBoolean(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                boolean bl = config.get(category, key, false).getBoolean();
                return bl;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, String value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            String set = config.get(category, key, value).getString();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, int value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            int set = config.get(category, key, value).getInt();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, boolean value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            boolean set = config.get(category, key, value).getBoolean();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, long value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            long set = config.get(category, key, (double)value).getLong();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, double value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            double set = config.get(category, key, value).getDouble();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, short value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            int set = config.get(category, key, (int)value).getInt();
            config.getCategory(category).get(key).set(Integer.valueOf(value).intValue());
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, byte value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            int set = config.get(category, key, (int)value).getInt();
            config.getCategory(category).get(key).set(Integer.valueOf(value).intValue());
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String category, String key, float value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            double set = config.get(category, key, (double)value).getDouble();
            config.getCategory(category).get(key).set(Double.valueOf(value).doubleValue());
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
    }

    public static boolean hasCategory(String category) {
        config = new Configuration(new File(file));
        try {
            config.load();
            boolean bl = config.hasCategory(category);
            return bl;
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return false;
    }

    public static boolean hasKey(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (!config.hasCategory(category)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = config.getCategory(category).containsKey(key);
            return bl;
        }
        catch (Exception e) {
            System.out.println("Cannot load configuration file!");
        }
        finally {
            config.save();
        }
        return false;
    }

    public static void setFile(String filename) {
        file = "config/" + filename;
    }

    public static String getFile() {
        return file;
    }

    static {
        file = "config/modID.cfg";
    }
}

