/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender;

import java.util.concurrent.Callable;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.telepathicgrunt.worldblender.WorldBlender;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import net.telepathicgrunt.worldblender.the_blender.ConfigBlacklisting;
import net.telepathicgrunt.worldblender.the_blender.PerformBiomeBlending;
import net.telepathicgrunt.worldblender.the_blender.ResourceLocationPrinting;
import net.telepathicgrunt.worldblender.the_blender.dedicated_mod_support.DimDungeonsCompatibility;
import net.telepathicgrunt.worldblender.the_blender.dedicated_mod_support.TerraForgedCompatibility;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="world_blender", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonModBusEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void latestCommonSetup(FMLLoadCompleteEvent event) {
        DeferredWorkQueue.runLater(CommonModBusEventHandler::beginSetup);
    }

    public static void beginSetup() {
        ConfigBlacklisting.setupBlackLists();
        PerformBiomeBlending.setupBiomes();
        try {
            CommonModBusEventHandler.runIfModIsLoaded("dimdungeons", () -> () -> DimDungeonsCompatibility.addDDDungeons());
        }
        catch (Exception e) {
            WorldBlender.LOGGER.log(Level.INFO, "ERROR: Failed to setup compatibility with Dimensional Dungeons. Their dungeons will not spawn in World Blender's dimension now. Please let the developer of World Blender know about this!");
            e.printStackTrace();
        }
        try {
            CommonModBusEventHandler.runIfModIsLoaded("terraforged", () -> () -> TerraForgedCompatibility.addTerraForgedtrees());
        }
        catch (Exception e) {
            WorldBlender.LOGGER.log(Level.INFO, "ERROR: Failed to setup compatibility with Terraforged. Their trees and stuff will not spawn in World Blender's dimension now. Please let the developer of World Blender know about this!");
            e.printStackTrace();
        }
        if (WBConfig.resourceLocationDump) {
            ResourceLocationPrinting.printAllResourceLocations();
        }
    }

    public static void runIfModIsLoaded(String modid, Callable<Runnable> toRun) throws Exception {
        if (ModList.get().isLoaded(modid)) {
            toRun.call().run();
        }
    }
}

