/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender;

import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.worldblender.ClientEvents;
import net.telepathicgrunt.worldblender.biome.WBBiomes;
import net.telepathicgrunt.worldblender.blocks.WBBlocks;
import net.telepathicgrunt.worldblender.blocks.WBPortalSpawning;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import net.telepathicgrunt.worldblender.features.WBFeatures;
import net.telepathicgrunt.worldblender.networking.MessageHandler;
import net.telepathicgrunt.worldblender.worldtype.WBWorldType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="world_blender")
public class WorldBlender {
    public static final String MODID = "world_blender";
    public static final Logger LOGGER = LogManager.getLogger((String)"world_blender");
    public static WorldType WBWorldType;

    public WorldBlender() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::modConfig);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, WBConfig.SERVER_SPEC);
        WBBlocks.registerAll(modEventBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.subscribeClientEvents(modEventBus, forgeBus));
    }

    public void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
        String entryValue;
        ServerProperties serverProperties = ((DedicatedServer)event.getServerSupplier().get()).func_213221_d_();
        if (serverProperties != null && (entryValue = serverProperties.field_73672_b.getProperty("use-modded-worldtype")) != null && entryValue.equals("world-blender")) {
            serverProperties.field_219023_q = WBWorldType;
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        WBWorldType = new WBWorldType();
        MessageHandler.init();
        WBPortalSpawning.generateRequiredBlockList(WBConfig.requiredBlocksInChests);
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == WBConfig.SERVER_SPEC) {
            WBConfig.refreshServer();
        }
    }

    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T entry, String registryKey) {
        entry.setRegistryName(new ResourceLocation(MODID, registryKey));
        registry.register(entry);
        return entry;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            WBBiomes.registerBiomes(event);
        }

        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            WBFeatures.registerFeatures(event);
        }

        @SubscribeEvent
        public static void registerSurfaceBuilder(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            WorldBlender.register(ForgeRegistries.SURFACE_BUILDERS, WBBiomes.BLENDED_SURFACE_BUILDER, "blended_surface_builder");
        }
    }
}

