/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.telepathicgrunt.worldblender.blocks.WBBlocks;
import net.telepathicgrunt.worldblender.blocks.WBPortalTileEntity;
import net.telepathicgrunt.worldblender.dimension.WBDimensionRegistration;

public class WBPortalBlock
extends ContainerBlock {
    protected static final VoxelShape COLLISION_BOX = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    protected WBPortalBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_151646_E).func_200942_a().func_200951_a(6).func_200948_a(-1.0f, 3600000.0f).func_222380_e());
    }

    public TileEntity func_196283_a_(IBlockReader blockReader) {
        return new WBPortalTileEntity();
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos position, Entity entity) {
        TileEntity tileentity = world.func_175625_s(position);
        if (tileentity instanceof WBPortalTileEntity) {
            WBPortalTileEntity wbtile = (WBPortalTileEntity)tileentity;
            if (!world.field_72995_K && !wbtile.isCoolingDown() && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-position.func_177958_n()), (double)(-position.func_177956_o()), (double)(-position.func_177952_p()))), (VoxelShape)COLLISION_BOX, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                MinecraftServer minecraftServer = entity.func_184102_h();
                ServerWorld destinationWorld = minecraftServer.func_71218_a(world.field_73011_w.func_186058_p() == WBDimensionRegistration.worldblender() ? DimensionType.field_223227_a_ : WBDimensionRegistration.worldblender());
                ServerWorld originalWorld = minecraftServer.func_71218_a(entity.field_71093_bK);
                BlockPos destPos = null;
                boolean portalOrChestFound = false;
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)position.func_177982_a(-4, -position.func_177956_o(), -4), (BlockPos)position.func_177982_a(4, 255 - position.func_177956_o(), 4))) {
                    Block blockNearTeleport = destinationWorld.func_180495_p(blockpos).func_177230_c();
                    if (blockNearTeleport == WBBlocks.WORLD_BLENDER_PORTAL.get()) {
                        if (destPos == null || Math.abs(blockpos.func_177958_n() - position.func_177958_n()) < Math.abs(destPos.func_177958_n() - position.func_177958_n()) && Math.abs(blockpos.func_177952_p() - position.func_177952_p()) < Math.abs(destPos.func_177952_p() - position.func_177952_p())) {
                            destPos = blockpos.func_185334_h();
                        }
                        portalOrChestFound = true;
                        WBPortalTileEntity wbtile2 = (WBPortalTileEntity)destinationWorld.func_175625_s(blockpos);
                        wbtile2.triggerCooldown();
                        continue;
                    }
                    if (!blockNearTeleport.getTags().contains(Tags.Blocks.CHESTS.func_199886_b())) continue;
                    if (destPos == null) {
                        destPos = blockpos.func_185334_h();
                    }
                    portalOrChestFound = true;
                }
                if (!portalOrChestFound) {
                    destPos = destinationWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, position);
                    if (destinationWorld.func_201672_e().field_73011_w.func_186058_p() == WBDimensionRegistration.worldblender()) {
                        destinationWorld.func_175656_a(destPos, Blocks.field_150350_a.func_176223_P());
                        destinationWorld.func_175656_a(destPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                        destinationWorld.func_175656_a(destPos, ((Block)WBBlocks.WORLD_BLENDER_PORTAL.get()).func_176223_P());
                        WBPortalTileEntity wbtile2 = (WBPortalTileEntity)destinationWorld.func_175625_s(destPos);
                        wbtile2.triggerCooldown();
                    }
                }
                wbtile.teleportEntity(entity, destPos, destinationWorld, originalWorld);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTrace) {
        if (playerEntity.func_213453_ef() && ((WBPortalTileEntity)world.func_175625_s(blockPos)).isRemoveable()) {
            if (world.field_72995_K) {
                this.createLotsOfParticles(blockState, world, blockPos, world.field_73012_v);
                return ActionResultType.SUCCESS;
            }
            world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState blockState, World world, BlockPos position, Random random) {
        TileEntity tileentity = world.func_175625_s(position);
        if (tileentity instanceof WBPortalTileEntity && random.nextFloat() < 0.09f) {
            double xPos = (double)position.func_177958_n() + (double)random.nextFloat();
            double yPos = (double)position.func_177956_o() + (double)random.nextFloat();
            double zPos = (double)position.func_177952_p() + (double)random.nextFloat();
            double xVelocity = ((double)random.nextFloat() - 0.5) * 0.08;
            double yVelocity = ((double)random.nextFloat() - 0.5) * 0.13;
            double zVelocity = ((double)random.nextFloat() - 0.5) * 0.08;
            world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, xPos, yPos, zPos, xVelocity, yVelocity, zVelocity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void createLotsOfParticles(BlockState blockState, World world, BlockPos position, Random random) {
        TileEntity tileentity = world.func_175625_s(position);
        if (tileentity instanceof WBPortalTileEntity) {
            for (int i = 0; i < 50; ++i) {
                double xPos = (double)position.func_177958_n() + (double)random.nextFloat();
                double yPos = (double)position.func_177956_o() + (double)random.nextFloat();
                double zPos = (double)position.func_177952_p() + (double)random.nextFloat();
                double xVelocity = ((double)random.nextFloat() - 0.5) * 0.08;
                double yVelocity = ((double)random.nextFloat() - 0.5) * 0.13;
                double zVelocity = ((double)random.nextFloat() - 0.5) * 0.08;
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, xPos, yPos, zPos, xVelocity, yVelocity, zVelocity);
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return ItemStack.field_190927_a;
    }

    public boolean canBucketPlace(BlockState p_225541_1_, Fluid p_225541_2_) {
        return false;
    }
}

