/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.worldblender.blocks.WBPortalTileEntity;
import net.telepathicgrunt.worldblender.blocks.WBRenderTexturingState;

@OnlyIn(value=Dist.CLIENT)
public class WBPortalTileEntityRenderer
extends TileEntityRenderer<WBPortalTileEntity> {
    public static final ResourceLocation MAIN_TEXTURE = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static final ResourceLocation ADDITIVE_TEXTURE = new ResourceLocation("textures/misc/forcefield.png");
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> WB_RENDER_TYPE = (List)IntStream.range(0, 9).mapToObj(index -> WBPortalTileEntityRenderer.getWBPortal(index + 1)).collect(ImmutableList.toImmutableList());

    public WBPortalTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(WBPortalTileEntity tileEntity, float partialTicks, MatrixStack modelMatrix, IRenderTypeBuffer renderBuffer, int combinedLightIn, int combinedOverlayIn) {
        RANDOM.setSeed(31100L);
        double distance = tileEntity.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int passes = this.getPasses(distance);
        Matrix4f matrix4f = modelMatrix.func_227866_c_().func_227870_a_();
        this.drawColor(tileEntity, 0.15f, matrix4f, renderBuffer.getBuffer(WB_RENDER_TYPE.get(0)));
        for (int currentPass = 1; currentPass < passes; ++currentPass) {
            this.drawColor(tileEntity, 2.2f / (float)(20 - currentPass), matrix4f, renderBuffer.getBuffer(WB_RENDER_TYPE.get(currentPass)));
        }
    }

    private void drawColor(WBPortalTileEntity tileEntity, float modifier, Matrix4f matrix4f, IVertexBuilder vertexBuilder) {
        float coolDownEffect = tileEntity.isCoolingDown() ? 0.7f - tileEntity.getCoolDown() / 1200.0f : 0.85f;
        float red = RANDOM.nextFloat() * 3.95f * modifier * coolDownEffect + tileEntity.getCoolDown() / 2800.0f;
        float green = RANDOM.nextFloat() * 2.95f * modifier * coolDownEffect;
        float blue = RANDOM.nextFloat() * 3.0f * modifier * coolDownEffect;
        this.setVertexColor(tileEntity, matrix4f, vertexBuilder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, red, green, blue, Direction.SOUTH);
        this.setVertexColor(tileEntity, matrix4f, vertexBuilder, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, red, green, blue, Direction.NORTH);
        this.setVertexColor(tileEntity, matrix4f, vertexBuilder, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, red, green, blue, Direction.EAST);
        this.setVertexColor(tileEntity, matrix4f, vertexBuilder, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, red, green, blue, Direction.WEST);
        this.setVertexColor(tileEntity, matrix4f, vertexBuilder, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, red, green, blue, Direction.DOWN);
        this.setVertexColor(tileEntity, matrix4f, vertexBuilder, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, red, green, blue, Direction.UP);
    }

    private void setVertexColor(WBPortalTileEntity tileEntity, Matrix4f matrix4f, IVertexBuilder vertexBuilder, float pos1, float pos2, float pos3, float pos4, float pos5, float pos6, float pos7, float pos8, float red, float green, float blue, Direction direction) {
        if (tileEntity.shouldRenderFace(direction)) {
            vertexBuilder.func_227888_a_(matrix4f, pos1, pos3, pos5).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(matrix4f, pos2, pos3, pos6).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(matrix4f, pos2, pos4, pos7).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(matrix4f, pos1, pos4, pos8).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        }
    }

    protected int getPasses(double distanceAway) {
        if (distanceAway > 36864.0) {
            return 1;
        }
        if (distanceAway > 25600.0) {
            return 2;
        }
        if (distanceAway > 16384.0) {
            return 3;
        }
        if (distanceAway > 9216.0) {
            return 4;
        }
        if (distanceAway > 4096.0) {
            return 5;
        }
        if (distanceAway > 1024.0) {
            return 6;
        }
        if (distanceAway > 576.0) {
            return 7;
        }
        return 8;
    }

    public static RenderType getWBPortal(int layer) {
        RenderState.TextureState renderstate$texturestate;
        RenderState.TransparencyState renderstate$transparencystate;
        if (layer <= 1) {
            renderstate$transparencystate = RenderState.field_228515_g_;
            renderstate$texturestate = new RenderState.TextureState(MAIN_TEXTURE, false, false);
        } else if (layer <= 3) {
            renderstate$transparencystate = RenderState.field_228511_c_;
            renderstate$texturestate = new RenderState.TextureState(ADDITIVE_TEXTURE, true, false);
        } else {
            renderstate$transparencystate = RenderState.field_228511_c_;
            renderstate$texturestate = new RenderState.TextureState(ADDITIVE_TEXTURE, false, false);
        }
        return RenderType.func_228633_a_((String)"world_blender_portal", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)90, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(renderstate$transparencystate).func_228724_a_(renderstate$texturestate).func_228725_a_((RenderState.TexturingState)new WBRenderTexturingState.WBPortalTexturingState(layer)).func_228717_a_(RenderState.field_228503_M_).func_228728_a_(false));
    }
}

