/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.configs;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class WBConfig {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static boolean allowVanillaBiomeImport;
    public static boolean allowModdedBiomeImport;
    public static boolean disallowLaggyFeatures;
    public static boolean preventFallingBlocks;
    public static boolean containFloatingLiquids;
    public static boolean preventLavaTouchingWater;
    public static boolean allowVanillaFeatures;
    public static boolean allowVanillaStructures;
    public static boolean allowVanillaCarvers;
    public static boolean allowVanillaSpawns;
    public static boolean allowVanillaSurfaces;
    public static boolean allowModdedFeatures;
    public static boolean allowModdedStructures;
    public static boolean allowModdedCarvers;
    public static boolean allowModdedSpawns;
    public static boolean allowModdedSurfaces;
    public static String blanketBlacklist;
    public static String blacklistedFeatures;
    public static String blacklistedStructures;
    public static String blacklistedCarvers;
    public static String blacklistedSpawns;
    public static String blacklistedBiomeSurfaces;
    public static boolean resourceLocationDump;
    public static int uniqueBlocksNeeded;
    public static String activationItem;
    public static String requiredBlocksInChests;
    public static boolean consumeChests;
    public static double surfaceScale;
    public static boolean spawnEnderDragon;
    public static boolean carversCanCarveMoreBlocks;
    public static boolean doesMapCursorSpin;

    public static void refreshServer() {
        surfaceScale = (Double)WBConfig.SERVER.surfaceScale.get();
        spawnEnderDragon = (Boolean)WBConfig.SERVER.spawnEnderDragon.get();
        carversCanCarveMoreBlocks = (Boolean)WBConfig.SERVER.carversCanCarveMoreBlocks.get();
        doesMapCursorSpin = (Boolean)WBConfig.SERVER.doesMapCursorSpin.get();
        disallowLaggyFeatures = (Boolean)WBConfig.SERVER.disallowLaggyFeatures.get();
        preventFallingBlocks = (Boolean)WBConfig.SERVER.preventFallingBlocks.get();
        containFloatingLiquids = (Boolean)WBConfig.SERVER.containFloatingLiquids.get();
        preventLavaTouchingWater = (Boolean)WBConfig.SERVER.preventLavaTouchingWater.get();
        allowVanillaBiomeImport = (Boolean)WBConfig.SERVER.allowVanillaBiomeImport.get();
        allowModdedBiomeImport = (Boolean)WBConfig.SERVER.allowModdedBiomeImport.get();
        allowVanillaFeatures = (Boolean)WBConfig.SERVER.allowVanillaFeatures.get();
        allowVanillaStructures = (Boolean)WBConfig.SERVER.allowVanillaStructures.get();
        allowVanillaCarvers = (Boolean)WBConfig.SERVER.allowVanillaCarvers.get();
        allowVanillaSpawns = (Boolean)WBConfig.SERVER.allowVanillaSpawns.get();
        allowVanillaSurfaces = (Boolean)WBConfig.SERVER.allowVanillaSurfaces.get();
        allowModdedFeatures = (Boolean)WBConfig.SERVER.allowModdedFeatures.get();
        allowModdedStructures = (Boolean)WBConfig.SERVER.allowModdedStructures.get();
        allowModdedCarvers = (Boolean)WBConfig.SERVER.allowModdedCarvers.get();
        allowModdedSpawns = (Boolean)WBConfig.SERVER.allowModdedSpawns.get();
        allowModdedSurfaces = (Boolean)WBConfig.SERVER.allowModdedSurfaces.get();
        blanketBlacklist = (String)WBConfig.SERVER.blanketBlacklist.get();
        blacklistedFeatures = (String)WBConfig.SERVER.blacklistedFeatures.get();
        blacklistedStructures = (String)WBConfig.SERVER.blacklistedStructures.get();
        blacklistedCarvers = (String)WBConfig.SERVER.blacklistedCarvers.get();
        blacklistedSpawns = (String)WBConfig.SERVER.blacklistedSpawns.get();
        blacklistedBiomeSurfaces = (String)WBConfig.SERVER.blacklistedBiomeSurfaces.get();
        resourceLocationDump = (Boolean)WBConfig.SERVER.resourceLocationDump.get();
        uniqueBlocksNeeded = (Integer)WBConfig.SERVER.uniqueBlocksNeeded.get();
        activationItem = (String)WBConfig.SERVER.activationItem.get();
        requiredBlocksInChests = (String)WBConfig.SERVER.requiredBlocksInChests.get();
        consumeChests = (Boolean)WBConfig.SERVER.consumeChests.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        allowVanillaBiomeImport = true;
        allowModdedBiomeImport = true;
        disallowLaggyFeatures = true;
        preventFallingBlocks = true;
        containFloatingLiquids = true;
        preventLavaTouchingWater = true;
        allowVanillaFeatures = true;
        allowVanillaStructures = true;
        allowVanillaCarvers = true;
        allowVanillaSpawns = true;
        allowVanillaSurfaces = true;
        allowModdedFeatures = true;
        allowModdedStructures = true;
        allowModdedCarvers = true;
        allowModdedSpawns = true;
        allowModdedSurfaces = true;
        blanketBlacklist = "ultra_amplified_dimension*";
        blacklistedFeatures = "";
        blacklistedStructures = "";
        blacklistedCarvers = "";
        blacklistedSpawns = "";
        blacklistedBiomeSurfaces = "";
        resourceLocationDump = false;
        uniqueBlocksNeeded = 216;
        activationItem = "minecraft:nether_star";
        requiredBlocksInChests = "";
        consumeChests = true;
        surfaceScale = 240.0;
        spawnEnderDragon = false;
        carversCanCarveMoreBlocks = true;
        doesMapCursorSpin = true;
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.DoubleValue surfaceScale;
        public final ForgeConfigSpec.BooleanValue spawnEnderDragon;
        public final ForgeConfigSpec.BooleanValue carversCanCarveMoreBlocks;
        public final ForgeConfigSpec.BooleanValue doesMapCursorSpin;
        public final ForgeConfigSpec.BooleanValue allowVanillaBiomeImport;
        public final ForgeConfigSpec.BooleanValue allowModdedBiomeImport;
        public final ForgeConfigSpec.BooleanValue disallowLaggyFeatures;
        public final ForgeConfigSpec.BooleanValue preventFallingBlocks;
        public final ForgeConfigSpec.BooleanValue containFloatingLiquids;
        public final ForgeConfigSpec.BooleanValue preventLavaTouchingWater;
        public final ForgeConfigSpec.BooleanValue allowVanillaFeatures;
        public final ForgeConfigSpec.BooleanValue allowVanillaStructures;
        public final ForgeConfigSpec.BooleanValue allowVanillaCarvers;
        public final ForgeConfigSpec.BooleanValue allowVanillaSpawns;
        public final ForgeConfigSpec.BooleanValue allowVanillaSurfaces;
        public final ForgeConfigSpec.BooleanValue allowModdedFeatures;
        public final ForgeConfigSpec.BooleanValue allowModdedStructures;
        public final ForgeConfigSpec.BooleanValue allowModdedCarvers;
        public final ForgeConfigSpec.BooleanValue allowModdedSpawns;
        public final ForgeConfigSpec.BooleanValue allowModdedSurfaces;
        public final ForgeConfigSpec.ConfigValue<String> blanketBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedFeatures;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedStructures;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedCarvers;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedSpawns;
        public final ForgeConfigSpec.ConfigValue<String> blacklistedBiomeSurfaces;
        public final ForgeConfigSpec.BooleanValue resourceLocationDump;
        public final ForgeConfigSpec.IntValue uniqueBlocksNeeded;
        public final ForgeConfigSpec.ConfigValue<String> activationItem;
        public final ForgeConfigSpec.ConfigValue<String> requiredBlocksInChests;
        public final ForgeConfigSpec.BooleanValue consumeChests;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Misc Options");
            this.surfaceScale = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n The size of the different kinds of surfaces. Higher numbers means\r\n each surface will be larger but might make some surfaces harder to find. Lower numbers means the surfaces are smaller but could become too chaotic or small for some features to spawn on.\r\n").translation("world_blender.config.misc.surfacescale").defineInRange("surfaceScale", 240.0, 1.0, 100000.0);
            this.spawnEnderDragon = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n If true, the Enderdragon will spawn at world origin in the\r\n World Blender dimension and can respawn if you put back the\r\n End Crystals on the podiums. Once killed, the podium's portal \r\n will take you to the End where you can battle the End's Enderdragon. \r\n \r\n And yes, you can respawn the EnderDragon by placing 4 End Crystals \r\n on the edges of the Bedrock Podium. \r\n \r\n If set to false, the Enderdragon will not spawn.\r\n NOTE: Once the Enderdragon is spawned, changing this to false will not despawn the Enderdragon. Also, this option will not\r\n work in the World Blender Worldtype due to how fight managers are \r\n set up. It will only work for the dimension. \r\n").translation("world_blender.config.misc.spawnenderdragon").define("spawnEnderDragon", false);
            this.carversCanCarveMoreBlocks = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n If true, carvers (mainly vanilla caves and ravines) can now carve\r\n out Netherrack, End Stone, and some modded blocks as well.\r\n \r\n If turned off, you might see Vanilla caves and stuff gets cutoff \r\n by a wall of End Stone, Netherrack, or modded blocks. \r\n").translation("world_blender.config.misc.carversCanCarveMoreBlocks").define("carversCanCarveMoreBlocks", true);
            this.doesMapCursorSpin = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Makes the map cursor spin when in World Blender Dimension.\r\n").translation("world_blender.config.misc.doesmapcursorspin").define("doesMapCursorSpin", true);
            builder.pop();
            builder.push("Optimization Options");
            this.disallowLaggyFeatures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Will make vanilla bamboo, lava, and fire features and will try to \r\n make modded bamboo, lava, and fire features not spawn at all\r\n in order to help reduce lag in the world due to bamboo\r\n breaking like crazy or fire spreading rapidly.\r\n \r\n If all else fail, do /gamerule doFireTick false to reduce fire lag.\r\n").translation("world_blender.config.optimization.disallowlaggyvanillafeatures").define("disallowLaggyVanillaFeatures", true);
            this.preventFallingBlocks = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Will try its best to place Terracotta blocks under all floating\r\n fallable blocks to prevent lag when the blocks begins to fall.\r\n").translation("world_blender.config.optimization.preventfallingblocks").define("preventFallingBlocks", true);
            this.containFloatingLiquids = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n This will also place Terracotta next to fluids to try and prevent.\r\n them from floating and then flowing downward like crazy.\r\n \r\n It isn't perfect but it does do mostly a good job with how\r\n messy and chaotic having all features and carvers together is.\r\n").translation("world_blender.config.optimization.containfloatingliquids").define("containFloatingLiquids", true);
            this.preventLavaTouchingWater = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Will place Obsidian to separate lava tagged fluids \r\n from water tagged fluids underground.\r\n").translation("world_blender.config.optimization.preventlavatouchingwater").define("preventLavaTouchingWater", true);
            builder.pop();
            builder.push("Vanilla Options");
            this.allowVanillaBiomeImport = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension can import anything from vanilla biomes.\r\n Note: If the other vanilla stuff options are set to true and you \r\n have the import from modded biome option set to true as well, then\r\n vanilla stuff can still get imported if a modded biome has them.\r\n").translation("world_blender.config.vanilla.allowvanillabiomeimport").define("allowVanillaBiomeImport", true);
            this.allowVanillaFeatures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports features like trees, plants, ores, etc.\r\n").translation("world_blender.config.vanilla.allowvanillafeatures").define("allowVanillaFeatures", true);
            this.allowVanillaStructures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports structures like temples, villages, etc.\r\n").translation("world_blender.config.vanilla.allowvanillastructures").define("allowVanillaStructures", true);
            this.allowVanillaCarvers = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports carvers like caves, ravines, etc.\r\n").translation("world_blender.config.vanilla.allowvanillacarvers").define("allowVanillaCarvers", true);
            this.allowVanillaSpawns = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports natural mob spawns like zombies, cows, etc.\r\n").translation("world_blender.config.vanilla.allowvanillaspawns").define("allowVanillaSpawns", true);
            this.allowVanillaSurfaces = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports surfaces like desert's sand, giant tree taiga's podzol, etc.\r\n").translation("world_blender.config.vanilla.allowvanillasurfaces").define("allowVanillaSurfaces", true);
            builder.pop();
            builder.push("Modded Options");
            this.allowModdedBiomeImport = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension can import anything from modded biomes.\r\n Note: If the other vanilla stuff options are set to true and you\r\n this option set to true as well, then vanilla stuff can still\r\n get imported if a modded biome has vanilla stuff in it.\r\n").translation("world_blender.config.modded.allowmoddedbiomeimport").define("allowModdedBiomeImport", true);
            this.allowModdedFeatures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports features like trees, plants, ores, etc.\r\n").translation("world_blender.config.modded.allowmoddedfeatures").define("allowModdedFeatures", true);
            this.allowModdedStructures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports structures like temples, villages, etc.\r\n").translation("world_blender.config.modded.allowmoddedstructures").define("allowModdedStructures", true);
            this.allowModdedCarvers = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports carvers like caves, ravines, etc.\r\n").translation("world_blender.config.modded.allowmoddedcarvers").define("allowModdedCarvers", true);
            this.allowModdedSpawns = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports natural mob spawns like zombies, cows, etc.\r\n").translation("world_blender.config.modded.allowmoddedspawns").define("allowModdedSpawns", true);
            this.allowModdedSurfaces = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Decides if the dimension imports surfaces like desert's sand, giant tree taiga's podzol, etc.\r\n").translation("world_blender.config.modded.allowmoddedsurfaces").define("allowModdedSurfaces", true);
            builder.pop();
            builder.push("Portal Options");
            this.uniqueBlocksNeeded = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n At least many unique block items are needed to be in the eight\r\n chests (or other blocks with chest tag) to create the portal. \r\n \r\n Items with no block form will be ignored and not counted but still be consumed.\r\n \r\n If you set this to beyond 216 (maximum slots four 8 chests), make\r\n sure you have a mod that has a chest that has much more inventory  slots to fill or else you cannot ").translation("world_blender.config.portal.uniqueblocksneeded").defineInRange("uniqueBlocksNeeded", 216, 0, 1000);
            this.activationItem = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Item that you need in your hand when you're crouching and right\r\n clicking a chest block to begin the portal creation process.\r\n This activation item will then be consumed.\r\n \r\n NOTE: the 8 chests needs to be in a 2x2 pattern before this mod  starts checking the contents of the chests and then create the portal if there are enough unique blocks in the chests. \r\n You can remove a portal by crouch right clicking execpt for the\r\n portal block at world origin in World Blender dimension.\r\n").translation("world_blender.config.portal.activationitem").define("activationItem", (Object)"minecraft:nether_star");
            this.requiredBlocksInChests = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n You can specify what specific blocks are required to be in\r\n the chests to make the portal. Format is the block's resourcelocations\r\n with each block separated by a comma. Example:\r\n \"minecraft:dirt, minecraft:sand, minecraft:stone\"\r\n \r\nIf you specify 1 required block but the portal needs 3 blocks,\r\n players will need to place that one required block and any two \r\n other blocks into the chests.\r\n \r\n If you specify 4 required blocks but the portal needs 2 unique blocks,\r\n then players only needs to add any 2 of the 4 blocks to make the portal.\r\n").translation("world_blender.config.portal.requiredblocksinchests").define("requiredBlocksInChests", (Object)"");
            this.consumeChests = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n If true, portal creation will destroy the chests and all contents in it\r\n Non-block items and stacks of items will still be consumed.\r\n \r\n If set to false, the chests and contents will be dropped when portal is made.\r\n").translation("world_blender.config.portal.consumechests").define("consumeChests", true);
            builder.pop();
            builder.push("Resource Location Dump Option");
            this.resourceLocationDump = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Dumps all resource locations (IDs) for all mods into a new file\r\n called resourceLocationDump.txt and can be found by looking below\r\n the saves and mods folder in Minecraft's folder. The file is made if you set this option to true and then run modded Minecraft until you reach the title menu.\r\n\r\n Use this option to look up the resource location or name of features, biomes, blocks, carvers, structures, or entities that you want to blacklist.\r\n").translation("world_blender.config.resourcelocation.resourcelocationdump").define("resourceLocationDump", false);
            builder.pop();
            builder.push("Blacklist Options");
            this.blanketBlacklist = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n This option can let you blacklist entire biomes or mods to\r\n prevent any importing of any kind from them. You can also use\r\n terms to ban any biome that contains the terms too.\r\n \r\n To blacklist a mod's biome, you would enter the resourcelocation\r\n for the biome. That means you need to enter the mod's ID first,\r\n then put a : (semicolon), and then the ID of the biome.\r\n For example, to blacklist just vanilla's Ice Spike biome, you\r\n would put in minecraft:ice_spike and nothing will be imported\r\n from that specific biome.\r\n \r\n If you want to blacklist an entire mod itself so no importing\r\n will happen for any of its biome, just enter the mod's ID and thenr\n put an * at the end.r\n As default, Ultra Amplified Dimension is blacklisted because\r\n its features are not setup for normal worldgen and will completely\r\n destroy this dimension.\r\n \r\n To blacklist by key terms, just enter the term alone such as \"ocean\"\r\n and all biomes with ocean in their name will not be imported.\r\n \r\n NOTE: You can blacklist multiple things at a time. Just separate\r\n each entry with a , (comma). Here's an example blacklisting a mod\r\n and a vanilla biome at the same time: \r\n \"ultra_amplified_dimension*, minecraft:ice_spike\"\r\n").translation("world_blender.config.blacklist.blanketblacklist").define("blanketBlacklist", (Object)"ultra_amplified_dimension*");
            this.blacklistedFeatures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Blacklist features by key terms, mod ID, or their resourcelocation\r\n \r\n To blacklist by key terms, just enter the term alone such as \"tree\"\r\n and all features with tree in their name will not be imported.\r\n \r\n To blacklist by mod ID, just enter the mod ID with an * on the end such as\r\n \"ultra_amplified_dimension*\" and all features from that mod will not be imported.\r\n \r\n To blacklist a single feature, enter the mod ID, then :, and then the \r\n feature's name. For example, \"minecraft:icebergs\" will prevent vanilla's\r\n icebergs from being imported but allow other mod's icebergs to be imported.\r\n \r\n NOTE: You can blacklist multiple things at a time. Just separate\r\n each entry with a , (comma). Here's an example blacklisting all trees\r\n and vanilla's icebergs: \r\n \"tree, minecraft:iceberg\"\r\n").translation("world_blender.config.blacklist.blacklistedfeatures").define("blacklistedFeatures", (Object)"");
            this.blacklistedStructures = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Blacklist structures by key terms, mod ID, or their resourcelocation\r\n \r\n To blacklist by key terms, just enter the term alone such as \"temple\"\r\n and all features with temple in their name will not be imported.\r\n \r\n To blacklist by mod ID, just enter the mod ID with an * on the end such as\r\n \"ultra_amplified_dimension*\" and all structures from that mod will not be imported.\r\n \r\n To blacklist a single feature, enter the mod ID, then :, and then the \r\n feature's name. For example, \"minecraft:igloo\" will prevent vanilla's\r\n igloos from being imported but allow other mod's igloos to be imported.\r\n \r\n NOTE: You can blacklist multiple things at a time. Just separate\r\n each entry with a , (comma). Here's an example blacklisting all temples\r\n and vanilla's igloos: \r\n \"temple, minecraft:igloo\"\r\n").translation("world_blender.config.blacklist.blacklistedstructures").define("blacklistedStructures", (Object)"");
            this.blacklistedCarvers = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Blacklist carvers by key terms, mod ID, or their resourcelocation\r\n \r\n To blacklist by key terms, just enter the term alone such as \"cave\"\r\n and all carvers with cave in their name will not be imported if they\r\n are registered with a name. Not many mods register their carvers sadly.\r\n \r\n To blacklist by mod ID, just enter the mod ID with an * on the end such as\r\n \"ultra_amplified_dimension*\" and all carvers from that mod will not be imported.\r\n \r\n To blacklist a single feature, enter the mod ID, then :, and then the \r\n feature's name. For example, \"minecraft:underwater_canyon\" will prevent \r\n vanilla's underwater canyons (ravines) from being imported. For underwater\r\n caves, use \"minecraft:underwater_cave\" to stop them from being imported.\r\n \r\n NOTE: You can blacklist multiple things at a time. Just separate\r\n each entry with a , (comma). Here's an example blacklisting all caves\r\n and vanilla's underwater canyons: \r\n \"cave, minecraft:underwater_canyon\"\r\n").translation("world_blender.config.blacklist.blacklistedcarvers").define("blacklistedCarvers", (Object)"");
            this.blacklistedSpawns = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Blacklist natural spawning mobs by key terms,\r\n mod ID, or their resourcelocation\r\n \r\n To blacklist by key terms, just enter the term alone such as \"zombie\"\r\n and all mobs with zombie in their name will not be imported.\r\n \r\n To blacklist by mod ID, just enter the mod ID with an * on the end such as\r\n \"super_duper_mob_mod*\" and all mobs from that mod will not be imported.\r\n \r\n To blacklist a single mob, enter the mod ID, then :, and then the \r\n mob's name. For example, \"minecraft:ghast\" will prevent \r\n vanilla's ghast from being imported.\r\n \r\n As default, The Midnight's Night Stag is blacklisted because\r\n trying to spawn that mob outside The Mindnight's dimension will\r\n cause the world to hang forever.\r\n \r\n NOTE: You can blacklist multiple things at a time. Just separate\r\n each entry with a , (comma). Here's an example blacklisting all zombies\r\n and vanilla's ghasts: \r\n \"zombie, minecraft:ghast\"\r\n").translation("world_blender.config.blacklist.blacklistedspawns").define("blacklistedSpawns", (Object)"midnight:nightstag");
            this.blacklistedBiomeSurfaces = builder.comment(" \r\n-----------------------------------------------------\r\n\r\n Blacklist surfaces by key terms, mod ID, or by block's resourcelocation\r\n This will blacklist based on the very top most block that the surface uses.\r\n \r\n To blacklist by key terms, just enter the term alone such as \"sand\"\r\n and all biome surfaces that uses blocks with sand in its name will\r\n not be imported. After all, sand is coarse and rough and gets everywhere!\r\n \r\n To blacklist by mod ID, just enter the mod ID with an * on the end such as\r\n \"weird_biome_mod*\" and all biome surfaces from that mod will not be imported.\r\n \r\n To blacklist a block from being a surface, enter the mod ID, then :, and then the \r\n block's name. For example, \"minecraft:mycelium\" will prevent any surfaces that uses\r\n Mycelium blocks from being imported.\r\n \r\n Also, some biomes might add Air block as a surface block which will create pits in\r\n the surface that looks like it is missing the top layer of land. Add minecraft:air to \r\n this config to prevent these kinds of surfaces from being added.\r\n \r\n NOTE: You can blacklist multiple things at a time. Just separate\r\n each entry with a , (comma). Here's an example blacklisting all sand\r\n surfaces and vanilla Mushroom Biome's Mycelium surface: \r\n \"sand, minecraft:mycelium\"\r\n").translation("world_blender.config.blacklist.blacklistedbiomesurfaces").define("blacklistedBiomeSurfaces", (Object)"");
            builder.pop();
        }
    }
}

