/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.dimension;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.worldblender.biome.biomes.surfacebuilder.BlendedSurfaceBuilder;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import net.telepathicgrunt.worldblender.dimension.AltarManager;
import net.telepathicgrunt.worldblender.dimension.WBDragonManager;
import net.telepathicgrunt.worldblender.dimension.WBWorldSavedData;
import net.telepathicgrunt.worldblender.generation.WBBiomeProvider;

@Mod.EventBusSubscriber(modid="world_blender", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WBDimension
extends Dimension {
    private final float[] colorsSunriseSunset = new float[4];
    private AltarManager altarManager;
    private WBDragonManager dragonManager;

    public WBDimension(World world, DimensionType typeIn) {
        super(world, typeIn, 15.0f);
        for (int i = 0; i <= 15; ++i) {
            this.field_76573_f[i] = (float)i / 15.0f;
        }
    }

    public void func_186057_q() {
        if (this.field_76579_a instanceof ServerWorld) {
            if (this.altarManager != null) {
                this.altarManager.saveWBAltarData(this.field_76579_a);
            }
            if (this.dragonManager != null) {
                this.dragonManager.saveWBDragonData(this.field_76579_a);
            }
        }
    }

    public void func_186059_r() {
        if (this.field_76579_a instanceof ServerWorld) {
            if (this.altarManager == null) {
                this.altarManager = new AltarManager((ServerWorld)this.field_76579_a);
            } else {
                this.altarManager.tick();
            }
            if (this.dragonManager != null) {
                this.dragonManager.tick();
            } else if (WBConfig.spawnEnderDragon || WBWorldSavedData.get(this.field_76579_a).isDragonDataSaved()) {
                this.dragonManager = new WBDragonManager((ServerWorld)this.field_76579_a);
            }
        }
    }

    public ChunkGenerator<?> func_186060_c() {
        BlendedSurfaceBuilder.setPerlinSeed(this.field_76579_a.func_72905_C());
        return new OverworldChunkGenerator((IWorld)this.field_76579_a, (BiomeProvider)new WBBiomeProvider(this.field_76579_a), (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a());
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return IForgeDimension.SleepResult.DENY;
    }

    public boolean func_76567_e() {
        return true;
    }

    public BlockPos func_177496_h() {
        return null;
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        return null;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return null;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return WBConfig.doesMapCursorSpin;
    }

    public boolean func_177495_o() {
        return false;
    }

    public boolean func_76569_d() {
        return true;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        float f1 = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 155.0f;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return new Vec3d(0.0, 0.8, 0.9);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_76565_k() {
        return 0.011;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double fractionComponent = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(fractionComponent * Math.PI) / 2.0;
        return (float)(fractionComponent * 2.0 + d1) / 3.0f;
    }
}

