/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.telepathicgrunt.worldblender.dimension.WBDragonSpawnState;
import net.telepathicgrunt.worldblender.dimension.WBWorldSavedData;
import net.telepathicgrunt.worldblender.the_blender.ConfigBlacklisting;

public class WBDragonManager {
    private static final Predicate<Entity> VALID_PLAYER = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo((ITextComponent)new TranslationTextComponent("entity.minecraft.ender_dragon", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final ServerWorld world;
    private final BlockPattern portalPattern;
    private int ticksSinceDragonSeen;
    private int aliveCrystals;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean dragonKilled;
    private boolean previouslyKilled;
    private UUID dragonUniqueId;
    private BlockPos exitPortalLocation;
    private WBDragonSpawnState respawnState;
    private boolean generatedInitialFight = false;
    private int respawnStateTicks;
    private EnderDragonEntity enderDragon;
    private List<EnderCrystalEntity> crystals;
    private boolean noCrystalAlive = false;

    public WBDragonManager(ServerWorld serverWorld) {
        this.world = serverWorld;
        WBWorldSavedData savedData = WBWorldSavedData.get((World)serverWorld);
        if (savedData.isDragonDataSaved()) {
            this.dragonUniqueId = savedData.getDragonUUID();
            this.dragonKilled = savedData.isDragonKilled();
            this.previouslyKilled = savedData.isDragonPreviouslyKilled();
            this.generatedInitialFight = savedData.isInitialFightGenerated();
            if (savedData.isDragonRespawning()) {
                this.respawnState = WBDragonSpawnState.START;
            }
            this.exitPortalLocation = savedData.getEndAltarPosition();
        } else {
            this.dragonKilled = true;
            this.previouslyKilled = true;
        }
        this.portalPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).func_177659_a(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h))).func_177661_b();
    }

    public void saveWBDragonData(World world) {
        WBWorldSavedData.get(world).setDragonKilled(this.dragonKilled);
        WBWorldSavedData.get(world).setDragonPreviouslyKilled(this.previouslyKilled);
        WBWorldSavedData.get(world).setDragonRespawning(this.respawnState != null);
        WBWorldSavedData.get(world).setGeneratedInitialFight(this.generatedInitialFight);
        WBWorldSavedData.get(world).setDragonUUID(this.dragonUniqueId);
        WBWorldSavedData.get(world).setEndAltarPosition(this.exitPortalLocation);
        WBWorldSavedData.get(world).setDragonDataSaved(true);
        WBWorldSavedData.get(world).func_76185_a();
    }

    public void tick() {
        this.bossInfo.func_186758_d(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossInfo.func_186757_c().isEmpty()) {
            this.world.func_72863_F().func_217228_a(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean flag = this.isWorldOriginTicking();
            if (flag) {
                if (!this.dragonKilled && this.dragonUniqueId != null) {
                    this.enderDragon = (EnderDragonEntity)this.world.func_217461_a(this.dragonUniqueId);
                    if (this.enderDragon == null) {
                        this.dragonUniqueId = null;
                        this.dragonKilled = true;
                        this.saveWBDragonData((World)this.world);
                    }
                }
                if (!this.generatedInitialFight) {
                    this.generatePortalAndDragon();
                    this.generatedInitialFight = true;
                    this.saveWBDragonData((World)this.world);
                }
                if (this.respawnState != null) {
                    if (this.crystals == null) {
                        this.respawnState = null;
                        this.tryRespawnDragon();
                    }
                    if (this.crystals != null) {
                        this.respawnState.process(this.world, this, this.crystals, this.respawnStateTicks++, this.exitPortalLocation);
                    }
                } else {
                    this.tryRespawnDragon();
                }
                if (!this.dragonKilled && this.enderDragon != null && !this.enderDragon.field_70128_L) {
                    if (++this.ticksSinceDragonSeen >= 1200) {
                        this.findOrCreateDragon();
                        this.ticksSinceDragonSeen = 0;
                    } else if (this.enderDragon != null) {
                        this.dragonUpdate(this.enderDragon);
                    }
                    if (++this.ticksSinceCrystalsScanned >= 100 && !this.noCrystalAlive) {
                        this.findAliveCrystals();
                        this.ticksSinceCrystalsScanned = 0;
                    }
                    if (this.enderDragon.func_110143_aJ() <= 0.0f) {
                        this.enderDragon.func_184668_a(250);
                    }
                } else if (this.enderDragon != null && this.enderDragon.field_70128_L) {
                    this.processDragonDeath(this.enderDragon);
                    this.saveWBDragonData((World)this.world);
                }
            }
        } else {
            this.world.func_72863_F().func_217222_b(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
    }

    private void generatePortalAndDragon() {
        boolean flag = this.worldContainsEndPortal();
        if (flag) {
            this.previouslyKilled = true;
        } else {
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.generatePortal(false);
            }
        }
        this.findOrCreateDragon();
        this.dragonKilled = false;
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List list = this.world.func_217439_j();
        if (list.isEmpty()) {
            this.createNewDragon();
        } else {
            this.dragonUniqueId = ((EnderDragonEntity)list.get(0)).func_110124_au();
            this.enderDragon = (EnderDragonEntity)list.get(0);
        }
    }

    protected void setRespawnState(WBDragonSpawnState preparingToSummonPillars) {
        if (this.respawnState == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnStateTicks = 0;
        if (preparingToSummonPillars == WBDragonSpawnState.END) {
            this.respawnState = null;
            this.dragonKilled = false;
            EnderDragonEntity enderdragonentity = this.createNewDragon();
            for (ServerPlayerEntity serverplayerentity : this.bossInfo.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)enderdragonentity);
            }
        } else if (this.doesRespawnCrystalExist() != null) {
            this.respawnState = preparingToSummonPillars;
        }
    }

    private boolean worldContainsEndPortal() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Chunk chunk = this.world.func_212866_a_(x, z);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof EndPortalTileEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper findExitPortal() {
        int maxHeight;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Chunk chunk = this.world.func_212866_a_(x, z);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    BlockPattern.PatternHelper blockpattern$patternhelper;
                    if (!(tileentity instanceof EndPortalTileEntity) || (blockpattern$patternhelper = this.portalPattern.func_177681_a((IWorldReader)this.world, tileentity.func_174877_v())) == null) continue;
                    BlockPos blockpos = blockpattern$patternhelper.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.exitPortalLocation == null && blockpos.func_177958_n() == 0 && blockpos.func_177952_p() == 0) {
                        this.exitPortalLocation = blockpos;
                    }
                    return blockpattern$patternhelper;
                }
            }
        }
        for (int currentHeight = maxHeight = this.world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a).func_177956_o() + 1; currentHeight >= 0; --currentHeight) {
            BlockPattern.PatternHelper blockpattern$patternhelper1 = this.portalPattern.func_177681_a((IWorldReader)this.world, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), currentHeight, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (blockpattern$patternhelper1 == null) continue;
            if (this.exitPortalLocation == null) {
                this.exitPortalLocation = blockpattern$patternhelper1.func_177670_a(3, 3, 3).func_177508_d();
            }
            return blockpattern$patternhelper1;
        }
        return null;
    }

    private boolean isWorldOriginTicking() {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                IChunk ichunk = this.world.func_217353_a(x, z, ChunkStatus.field_222617_m, false);
                if (!(ichunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType chunkholder$locationtype = ((Chunk)ichunk).func_217321_u();
                if (chunkholder$locationtype.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayerEntity serverplayerentity : this.world.func_217490_a(VALID_PLAYER)) {
            this.bossInfo.func_186760_a(serverplayerentity);
            set.add(serverplayerentity);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.bossInfo.func_186757_c());
        set1.removeAll(set);
        for (ServerPlayerEntity serverplayerentity1 : set1) {
            this.bossInfo.func_186761_b(serverplayerentity1);
        }
    }

    private void findAliveCrystals() {
        this.ticksSinceCrystalsScanned = 0;
        this.aliveCrystals = 0;
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_214554_a((IWorld)this.world)) {
            this.aliveCrystals += this.world.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f()).size();
        }
        if (this.aliveCrystals == 0) {
            this.noCrystalAlive = true;
        }
    }

    public void processDragonDeath(EnderDragonEntity dragonEntity) {
        if (dragonEntity == null || dragonEntity.func_110124_au().equals(this.dragonUniqueId)) {
            this.bossInfo.func_186735_a(0.0f);
            this.bossInfo.func_186758_d(false);
            this.generatePortal(true);
            ServerWorld endWorld = this.world.func_73046_m().func_71218_a(DimensionType.field_223229_c_);
            BlockPos.Mutable blockPos = new BlockPos.Mutable(0, 255, 0);
            while (blockPos.func_177956_o() > 0 && endWorld.func_180495_p((BlockPos)blockPos) != Blocks.field_150357_h.func_176223_P()) {
                blockPos.func_189536_c(Direction.DOWN);
            }
            if (blockPos.func_177956_o() == 0) {
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        for (int height = 0; height <= 35; ++height) {
                            if (x * x + z * z < 15) {
                                endWorld.func_180501_a(blockPos.func_177982_a(x, 0, z), Blocks.field_150343_Z.func_176223_P(), 3);
                            }
                            blockPos.func_189536_c(Direction.UP);
                        }
                        blockPos.func_181079_c(0, 40, 0);
                    }
                }
            }
            if (!this.previouslyKilled) {
                this.world.func_175656_a(this.world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
            this.enderDragon = null;
        }
    }

    private void generatePortal(boolean portalActive) {
        if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("minecraft:end_podium"))) {
            return;
        }
        EndPodiumFeature endpodiumfeature = new EndPodiumFeature(portalActive);
        if (this.exitPortalLocation == null) {
            this.exitPortalLocation = this.world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            while (this.world.func_180495_p(this.exitPortalLocation).func_177230_c() == Blocks.field_150357_h && this.exitPortalLocation.func_177956_o() > this.world.func_181545_F()) {
                this.exitPortalLocation = this.exitPortalLocation.func_177977_b();
            }
        }
        endpodiumfeature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_222734_a((IWorld)this.world, this.world.func_72863_F().func_201711_g(), new Random(), this.exitPortalLocation);
    }

    private EnderDragonEntity createNewDragon() {
        this.world.func_175726_f(new BlockPos(0, 128, 0));
        EnderDragonEntity enderdragonentity = (EnderDragonEntity)EntityType.field_200802_p.func_200721_a((World)this.world);
        enderdragonentity.func_184670_cT().func_188758_a(PhaseType.field_188741_a);
        enderdragonentity.func_70012_b(0.0, 128.0, 0.0, this.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.world.func_217376_c((Entity)enderdragonentity);
        this.dragonUniqueId = enderdragonentity.func_110124_au();
        this.enderDragon = enderdragonentity;
        return enderdragonentity;
    }

    public void dragonUpdate(EnderDragonEntity dragon) {
        if (dragon.func_110124_au().equals(this.dragonUniqueId)) {
            this.bossInfo.func_186735_a(dragon.func_110143_aJ() / dragon.func_110138_aP());
            this.ticksSinceDragonSeen = 0;
            if (dragon.func_145818_k_()) {
                this.bossInfo.func_186739_a(dragon.func_145748_c_());
            }
        }
    }

    public void tryRespawnDragon() {
        if (this.dragonKilled && this.respawnState == null) {
            List<EnderCrystalEntity> list1;
            BlockPos blockpos = this.exitPortalLocation;
            if (blockpos == null) {
                BlockPattern.PatternHelper blockpattern$patternhelper = this.findExitPortal();
                if (blockpattern$patternhelper == null) {
                    this.generatePortal(true);
                }
                blockpos = this.exitPortalLocation;
            }
            if ((list1 = this.doesRespawnCrystalExist()) == null) {
                return;
            }
            this.respawnDragon(list1);
        }
    }

    private List<EnderCrystalEntity> doesRespawnCrystalExist() {
        BlockPos blockpos1 = this.exitPortalLocation.func_177981_b(1);
        ArrayList list1 = Lists.newArrayList();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            List list = this.world.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(blockpos1.func_177967_a(direction, 2)));
            if (list.isEmpty()) {
                return null;
            }
            list1.addAll(list);
        }
        return list1;
    }

    private void respawnDragon(List<EnderCrystalEntity> p_186093_1_) {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPattern.PatternHelper blockpattern$patternhelper = this.findExitPortal();
            while (blockpattern$patternhelper != null) {
                for (int i = 0; i < this.portalPattern.func_177684_c(); ++i) {
                    for (int j = 0; j < this.portalPattern.func_177685_b(); ++j) {
                        for (int k = 0; k < this.portalPattern.func_185922_a(); ++k) {
                            CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, k);
                            if (cachedblockinfo.func_177509_a().func_177230_c() != Blocks.field_150357_h && cachedblockinfo.func_177509_a().func_177230_c() != Blocks.field_150384_bq) continue;
                            this.world.func_175656_a(cachedblockinfo.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                blockpattern$patternhelper = this.findExitPortal();
            }
            this.respawnState = WBDragonSpawnState.START;
            this.respawnStateTicks = 0;
            this.generatePortal(false);
            this.crystals = p_186093_1_;
        }
    }

    public void resetSpikeCrystals() {
        for (EndSpikeFeature.EndSpike endspikefeature$endspike : EndSpikeFeature.func_214554_a((IWorld)this.world)) {
            for (EnderCrystalEntity endercrystalentity : this.world.func_217357_a(EnderCrystalEntity.class, endspikefeature$endspike.func_186153_f())) {
                endercrystalentity.func_184224_h(false);
                endercrystalentity.func_184516_a((BlockPos)null);
            }
        }
    }
}

