/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.generation.layer;

import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import net.telepathicgrunt.worldblender.biome.WBBiomes;

public enum MainBiomeLayer implements IAreaTransformer0
{
    INSTANCE;

    private static final int BLENDED_BIOME_ID;
    private static final int COLD_HILLS_BLENDED_BIOME_ID;
    private static final int MOUNTAINOUS_BLENDED_BIOME_ID;
    private static final int OCEAN_BLENDED_BIOME_ID;
    private static final int FROZEN_OCEAN_BLENDED_BIOME_ID;
    private static PerlinNoiseGenerator perlinGen;

    public int func_215735_a(INoiseRandom noise, int x, int z) {
        double perlinNoise = perlinGen.func_215464_a((double)x * 0.1, (double)z * 0.1, false);
        double perlinNoise2 = perlinGen.func_215464_a((double)x * 0.08 + 1000.0, (double)z * 0.08 + 1000.0, false);
        if (perlinNoise > 0.53) {
            return MOUNTAINOUS_BLENDED_BIOME_ID;
        }
        if (perlinNoise > -0.58) {
            if (perlinNoise2 < -0.75) {
                return COLD_HILLS_BLENDED_BIOME_ID;
            }
            return BLENDED_BIOME_ID;
        }
        return (double)noise.func_202696_a(100) / 800.0 + perlinNoise % 0.4 > -0.2 ? OCEAN_BLENDED_BIOME_ID : FROZEN_OCEAN_BLENDED_BIOME_ID;
    }

    public static void setSeed(long seed) {
        if (perlinGen == null) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            perlinGen = new PerlinNoiseGenerator(sharedseedrandom, 0, 0);
        }
    }

    static {
        BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.BLENDED_BIOME);
        COLD_HILLS_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.COLD_HILLS_BLENDED_BIOME);
        MOUNTAINOUS_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.MOUNTAINOUS_BLENDED_BIOME);
        OCEAN_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.OCEAN_BLENDED_BIOME);
        FROZEN_OCEAN_BLENDED_BIOME_ID = Registry.field_212624_m.func_148757_b((Object)WBBiomes.FROZEN_OCEAN_BLENDED_BIOME);
    }
}

