/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.the_blender;

import com.google.common.collect.Maps;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.DecoratedFlowerFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;

public class FeatureGrouping {
    private static final List<String> BAMBOO_FEATURE_KEYWORDS = Arrays.asList("bamboo");
    private static final List<String> LAGGY_FEATURE_KEYWORDS = Arrays.asList("lava", "fire", "bamboo", "sugar_cane");
    private static final ResourceLocation GNS_NETHER_SPREAD = new ResourceLocation("goodnightsleep:nether_splash");
    public static boolean bambooFound = false;
    public static final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> SMALL_PLANT_MAP = Maps.newHashMap();
    private static final List<String> SMALL_PLANT_KEYWORDS = Arrays.asList("grass", "flower", "rose", "plant", "bush", "fern");
    public static final Map<GenerationStage.Decoration, List<ConfiguredFeature<?, ?>>> LARGE_PLANT_MAP = Maps.newHashMap();
    private static final List<String> LARGE_PLANT_KEYWORDS = Arrays.asList("tree", "huge_mushroom", "big_mushroom", "poplar", "twiglet", "mangrove", "bramble");

    public static void setupFeatureMaps() {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            SMALL_PLANT_MAP.put(stage, new ArrayList());
            LARGE_PLANT_MAP.put(stage, new ArrayList());
            bambooFound = false;
        }
    }

    public static void clearFeatureMaps() {
        SMALL_PLANT_MAP.clear();
        LARGE_PLANT_MAP.clear();
    }

    public static boolean isLaggyFeature(GenerationStage.Decoration stage, ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
            DecoratedFeatureConfig decoratedConfig = (DecoratedFeatureConfig)configuredFeature.field_222738_b;
            ResourceLocation rl = null;
            if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202291_ak) {
                for (ConfiguredFeature nestedConfiguredFeature : ((MultipleWithChanceRandomFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_202454_a) {
                    rl = nestedConfiguredFeature.field_222737_a.getRegistryName();
                    if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                        bambooFound = true;
                    }
                    if (!FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS)) continue;
                    return true;
                }
            } else if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202292_al) {
                for (ConfiguredRandomFeatureList nestedConfiguredFeature : ((MultipleRandomFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_202449_a) {
                    rl = nestedConfiguredFeature.field_214842_a.field_222737_a.getRegistryName();
                    if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                        bambooFound = true;
                    }
                    if (!FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS)) continue;
                    return true;
                }
            } else if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_204620_ao) {
                for (ConfiguredFeature nestedConfiguredFeature : ((SingleRandomFeature)decoratedConfig.field_214689_a.field_222738_b).field_204628_a) {
                    rl = nestedConfiguredFeature.field_222737_a.getRegistryName();
                    if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                        bambooFound = true;
                    }
                    if (!FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS)) continue;
                    return true;
                }
            } else if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202293_am) {
                rl = ((TwoFeatureChoiceConfig)decoratedConfig.field_214689_a.field_222738_b).field_227285_a_.field_222737_a.getRegistryName();
                if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                    bambooFound = true;
                }
                if (FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS)) {
                    return true;
                }
                rl = ((TwoFeatureChoiceConfig)decoratedConfig.field_214689_a.field_222738_b).field_227286_b_.field_222737_a.getRegistryName();
                if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                    bambooFound = true;
                }
                if (FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS)) {
                    return true;
                }
            } else {
                rl = decoratedConfig.field_214689_a.field_222737_a == Feature.field_202289_ai ? ((BlockStateFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_227270_a_.func_177230_c().getRegistryName() : (decoratedConfig.field_214689_a.field_222737_a == Feature.field_206922_aF ? ((BlockWithContextConfig)decoratedConfig.field_214689_a.field_222738_b).field_206924_a.func_177230_c().getRegistryName() : (decoratedConfig.field_214689_a.field_222737_a == Feature.field_227248_z_ ? ((BlockClusterFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_227289_a_.func_225574_a_(new Random(0L), BlockPos.field_177992_a).func_177230_c().getRegistryName() : (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202295_ao ? ((LiquidsConfig)decoratedConfig.field_214689_a.field_222738_b).field_214678_a.func_206883_i().func_177230_c().getBlock().getRegistryName() : (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202290_aj ? ((OreFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_202444_d.getBlockState().func_177230_c().getBlock().getRegistryName() : (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202285_ae ? ((SphereReplaceConfig)decoratedConfig.field_214689_a.field_222738_b).field_214693_a.getBlockState().func_177230_c().getBlock().getRegistryName() : decoratedConfig.field_214689_a.field_222737_a.getRegistryName())))));
            }
            if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                bambooFound = true;
            }
            if (FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS) || rl != null && rl.equals((Object)GNS_NETHER_SPREAD)) {
                return true;
            }
        } else {
            ResourceLocation rl = configuredFeature.field_222737_a.getRegistryName();
            if (FeatureGrouping.keywordFoundInPath(rl, BAMBOO_FEATURE_KEYWORDS)) {
                bambooFound = true;
            }
            if (FeatureGrouping.keywordFoundInPath(rl, LAGGY_FEATURE_KEYWORDS)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checksAndAddSmallPlantFeatures(GenerationStage.Decoration stage, ConfiguredFeature<?, ?> configuredFeature) {
        if (SMALL_PLANT_MAP.get(stage).stream().anyMatch(vanillaConfigFeature -> FeatureGrouping.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature))) {
            return false;
        }
        if (configuredFeature.field_222737_a instanceof DecoratedFlowerFeature) {
            SMALL_PLANT_MAP.get(stage).add(configuredFeature);
            return true;
        }
        if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
            ResourceLocation rl;
            DecoratedFeatureConfig decoratedConfig = (DecoratedFeatureConfig)configuredFeature.field_222738_b;
            if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_227247_y_) {
                SMALL_PLANT_MAP.get(stage).add(configuredFeature);
                return true;
            }
            if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_227248_z_ && FeatureGrouping.keywordFoundInPath(rl = ((BlockClusterFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_227289_a_.func_225574_a_(new Random(0L), BlockPos.field_177992_a).func_177230_c().getRegistryName(), SMALL_PLANT_KEYWORDS)) {
                SMALL_PLANT_MAP.get(stage).add(configuredFeature);
                return true;
            }
        } else {
            ResourceLocation rl = configuredFeature.field_222737_a.getRegistryName();
            if (FeatureGrouping.keywordFoundInPath(rl, SMALL_PLANT_KEYWORDS)) {
                SMALL_PLANT_MAP.get(stage).add(configuredFeature);
                return true;
            }
        }
        return false;
    }

    public static boolean checksAndAddLargePlantFeatures(GenerationStage.Decoration stage, ConfiguredFeature<?, ?> configuredFeature) {
        if (LARGE_PLANT_MAP.get(stage).stream().anyMatch(vanillaConfigFeature -> FeatureGrouping.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature))) {
            return false;
        }
        if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
            DecoratedFeatureConfig decoratedConfig = (DecoratedFeatureConfig)configuredFeature.field_222738_b;
            ResourceLocation rl = null;
            if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202291_ak) {
                for (ConfiguredFeature nestedConfiguredFeature : ((MultipleWithChanceRandomFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_202454_a) {
                    rl = nestedConfiguredFeature.field_222737_a.getRegistryName();
                    if (!FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) continue;
                    return true;
                }
            } else if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202292_al) {
                for (ConfiguredRandomFeatureList nestedConfiguredFeature : ((MultipleRandomFeatureConfig)decoratedConfig.field_214689_a.field_222738_b).field_202449_a) {
                    rl = nestedConfiguredFeature.field_214842_a.field_222737_a.getRegistryName();
                    if (!FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) continue;
                    return true;
                }
            } else if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_204620_ao) {
                for (ConfiguredFeature nestedConfiguredFeature : ((SingleRandomFeature)decoratedConfig.field_214689_a.field_222738_b).field_204628_a) {
                    rl = nestedConfiguredFeature.field_222737_a.getRegistryName();
                    if (!FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) continue;
                    return true;
                }
            } else if (decoratedConfig.field_214689_a.field_222737_a == Feature.field_202293_am) {
                rl = ((TwoFeatureChoiceConfig)decoratedConfig.field_214689_a.field_222738_b).field_227285_a_.field_222737_a.getRegistryName();
                if (FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) {
                    return true;
                }
                rl = ((TwoFeatureChoiceConfig)decoratedConfig.field_214689_a.field_222738_b).field_227286_b_.field_222737_a.getRegistryName();
                if (FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) {
                    return true;
                }
            } else {
                rl = decoratedConfig.field_214689_a.field_222737_a.getRegistryName();
                if (FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) {
                    return true;
                }
            }
        } else {
            ResourceLocation rl = configuredFeature.field_222737_a.getRegistryName();
            if (FeatureGrouping.addFeatureToLargePlantMap(rl, configuredFeature, stage)) {
                return true;
            }
        }
        return false;
    }

    private static boolean addFeatureToLargePlantMap(ResourceLocation rl, ConfiguredFeature<?, ?> configuredFeature, GenerationStage.Decoration stage) {
        if (FeatureGrouping.keywordFoundInPath(rl, LARGE_PLANT_KEYWORDS)) {
            LARGE_PLANT_MAP.get(stage).add(configuredFeature);
            return true;
        }
        return false;
    }

    private static boolean keywordFoundInPath(ResourceLocation featureRL, List<String> keywordList) {
        if (featureRL != null) {
            String path = featureRL.func_110623_a();
            for (String keyword : keywordList) {
                if (!path.contains(keyword)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> feature1, ConfiguredFeature<?, ?> feature2) {
        block3: {
            try {
                Map feature1Map = (Map)feature1.func_222735_a((DynamicOps)NBTDynamicOps.field_210820_a).getMapValues().get();
                Map feature2Map = (Map)feature2.func_222735_a((DynamicOps)NBTDynamicOps.field_210820_a).getMapValues().get();
                if (feature1Map != null && feature2Map != null) {
                    return feature1Map.equals(feature2Map);
                }
            }
            catch (Exception e) {
                if (!(feature1.field_222738_b instanceof DecoratedFeatureConfig) || !(feature2.field_222738_b instanceof DecoratedFeatureConfig) || ((DecoratedFeatureConfig)feature1.field_222738_b).field_214689_a.field_222737_a != ((DecoratedFeatureConfig)feature2.field_222738_b).field_214689_a.field_222737_a) break block3;
                return true;
            }
        }
        return false;
    }
}

