/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.worldblender.the_blender;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.EndSpikeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.worldblender.biome.WBBiomes;
import net.telepathicgrunt.worldblender.biome.biomes.surfacebuilder.BlendedSurfaceBuilder;
import net.telepathicgrunt.worldblender.configs.WBConfig;
import net.telepathicgrunt.worldblender.features.WBFeatures;
import net.telepathicgrunt.worldblender.the_blender.ConfigBlacklisting;
import net.telepathicgrunt.worldblender.the_blender.FeatureGrouping;

public class PerformBiomeBlending {
    public static void setupBiomes() {
        FeatureGrouping.setupFeatureMaps();
        BlendedSurfaceBuilder.resetSurfaceList();
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("minecraft:end_spike"))) {
            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Feature.field_202296_ap.func_225566_b_((IFeatureConfig)new EndSpikeFeatureConfig(false, (List)ImmutableList.of(), null)).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e))));
        }
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (WBBiomes.biomes.contains(biome) || ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).func_110624_b().equals("minecraft") && !WBConfig.allowVanillaBiomeImport || !WBConfig.allowModdedBiomeImport || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.BLANKET, biome.getRegistryName())) continue;
            PerformBiomeBlending.addBiomeFeatures(biome);
            PerformBiomeBlending.addBiomeStructures(biome);
            PerformBiomeBlending.addBiomeCarvers(biome);
            PerformBiomeBlending.addBiomeNaturalMobs(biome);
            PerformBiomeBlending.addBiomeSurfaceConfig(biome);
        }
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature<?, ?> grassyFlowerFeature : FeatureGrouping.SMALL_PLANT_MAP.get(stage)) {
                if (!WBBiomes.BLENDED_BIOME.func_203607_a(stage).stream().noneMatch(addedConfigFeature -> FeatureGrouping.serializeAndCompareFeature(addedConfigFeature, grassyFlowerFeature))) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, grassyFlowerFeature));
            }
        }
        if (!WBConfig.disallowLaggyFeatures && FeatureGrouping.bambooFound) {
            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_214482_aJ.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.2f)).func_227228_a_(Placement.field_215038_x.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(160, 80.0, 0.3, Heightmap.Type.WORLD_SURFACE_WG)))));
        }
        if (WBConfig.carversCanCarveMoreBlocks) {
            Set<Block> allBlocksToCarve = BlendedSurfaceBuilder.blocksToCarve();
            for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
                for (ConfiguredCarver carver : WBBiomes.BLENDED_BIOME.func_203603_a(carverStage)) {
                    allBlocksToCarve.addAll(carver.field_222732_a.field_222718_j);
                    carver.field_222732_a.field_222718_j = allBlocksToCarve;
                }
            }
        }
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("world_blender:no_floating_liquids_or_falling_blocks"))) {
            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, WBFeatures.NO_FLOATING_LIQUIDS_OR_FALLING_BLOCKS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e))));
        }
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("world_blender:separate_lava_and_water"))) {
            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, WBFeatures.SEPARATE_LAVA_AND_WATER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e))));
        }
        FeatureGrouping.clearFeatureMaps();
        WBBiomes.VANILLA_TEMP_BIOME = null;
    }

    private static void addBiomeFeatures(Biome biome) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature configuredFeature : biome.func_203607_a(stage)) {
                if (!WBBiomes.BLENDED_BIOME.func_203607_a(stage).stream().noneMatch(addedConfigFeature -> FeatureGrouping.serializeAndCompareFeature(addedConfigFeature, configuredFeature))) continue;
                if (configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) {
                    ConfiguredFeature insideFeature = ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a;
                    if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, insideFeature.field_222737_a.getRegistryName()) || insideFeature.field_222737_a == Feature.field_202291_ak && ((MultipleWithChanceRandomFeatureConfig)insideFeature.field_222738_b).field_202454_a.stream().anyMatch(buriedFeature -> ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, buriedFeature.field_222737_a.getRegistryName())) || insideFeature.field_222737_a == Feature.field_202292_al && ((MultipleRandomFeatureConfig)insideFeature.field_222738_b).field_202449_a.stream().anyMatch(buriedFeature -> ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, buriedFeature.field_214842_a.field_222737_a.getRegistryName())) || insideFeature.field_222737_a == Feature.field_204620_ao && ((SingleRandomFeature)insideFeature.field_222738_b).field_204628_a.stream().anyMatch(buriedFeature -> ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, buriedFeature.field_222737_a.getRegistryName())) || insideFeature.field_222737_a == Feature.field_202293_am && (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, ((TwoFeatureChoiceConfig)insideFeature.field_222738_b).field_227285_a_.field_222737_a.getRegistryName()) || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, ((TwoFeatureChoiceConfig)insideFeature.field_222738_b).field_227286_b_.field_222737_a.getRegistryName()))) continue;
                }
                if (WBBiomes.VANILLA_TEMP_BIOME.func_203607_a(stage).stream().anyMatch(vanillaConfigFeature -> FeatureGrouping.serializeAndCompareFeature(vanillaConfigFeature, configuredFeature))) {
                    if (!((Boolean)WBConfig.SERVER.allowVanillaFeatures.get()).booleanValue() || FeatureGrouping.checksAndAddSmallPlantFeatures(stage, configuredFeature) || FeatureGrouping.isLaggyFeature(stage, configuredFeature) && WBConfig.disallowLaggyFeatures || configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214482_aJ) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
                    continue;
                }
                if (!((Boolean)WBConfig.SERVER.allowModdedFeatures.get()).booleanValue()) continue;
                if (!FeatureGrouping.checksAndAddSmallPlantFeatures(stage, configuredFeature) && FeatureGrouping.checksAndAddLargePlantFeatures(stage, configuredFeature)) {
                    WBBiomes.biomes.forEach(blendedBiome -> ((List)blendedBiome.field_201872_ah.get(stage)).add(0, configuredFeature));
                    continue;
                }
                if (FeatureGrouping.isLaggyFeature(stage, configuredFeature) && WBConfig.disallowLaggyFeatures || configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_214482_aJ) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
            }
        }
    }

    private static void addBiomeStructures(Biome biome) {
        block0: for (Structure structure : biome.field_201874_aj.keySet()) {
            boolean finishedFeaturePortion;
            if (!WBBiomes.BLENDED_BIOME.field_201874_aj.keySet().stream().noneMatch(struct -> struct == structure) || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.STRUCTURE, structure.getRegistryName())) continue;
            if (WBBiomes.VANILLA_TEMP_BIOME.field_201874_aj.keySet().stream().anyMatch(vanillaStructure -> vanillaStructure.getClass().equals(structure.getClass()))) {
                if (!((Boolean)WBConfig.SERVER.allowVanillaStructures.get()).booleanValue()) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_226711_a_(new ConfiguredFeature((Feature)structure, (IFeatureConfig)biome.field_201874_aj.get(structure))));
                finishedFeaturePortion = false;
                for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                    for (ConfiguredFeature configuredFeature : biome.func_203607_a(stage)) {
                        if (!(configuredFeature.field_222738_b instanceof DecoratedFeatureConfig) || !((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a.getClass().equals(structure.getClass())) continue;
                        if (((List)WBBiomes.BLENDED_BIOME.field_201872_ah.get(stage)).stream().noneMatch(addedFeature -> FeatureGrouping.serializeAndCompareFeature(addedFeature, configuredFeature))) {
                            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
                        }
                        finishedFeaturePortion = true;
                        break;
                    }
                    if (finishedFeaturePortion) continue block0;
                }
                continue;
            }
            if (!((Boolean)WBConfig.SERVER.allowModdedStructures.get()).booleanValue()) continue;
            WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_226711_a_(new ConfiguredFeature((Feature)structure, (IFeatureConfig)biome.field_201874_aj.get(structure))));
            finishedFeaturePortion = false;
            for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
                for (ConfiguredFeature configuredFeature : biome.func_203607_a(stage)) {
                    if (!configuredFeature.field_222737_a.getClass().equals(((IFeatureConfig)biome.field_201874_aj.get(structure)).getClass())) continue;
                    if (((List)WBBiomes.BLENDED_BIOME.field_201872_ah.get(stage)).stream().noneMatch(addedFeature -> FeatureGrouping.serializeAndCompareFeature(addedFeature, configuredFeature))) {
                        WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203611_a(stage, configuredFeature));
                    }
                    finishedFeaturePortion = true;
                    break;
                }
                if (finishedFeaturePortion) continue block0;
            }
        }
    }

    private static void addBiomeCarvers(Biome biome) {
        for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
            for (ConfiguredCarver carver : biome.func_203603_a(carverStage)) {
                if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.CARVER, carver.field_222732_a.getRegistryName()) || !WBBiomes.BLENDED_BIOME.func_203603_a(carverStage).stream().noneMatch(config -> config.field_222732_a == carver.field_222732_a)) continue;
                if (carver.field_222732_a.getRegistryName() != null && carver.field_222732_a.getRegistryName().func_110624_b().equals("minecraft")) {
                    if (!((Boolean)WBConfig.SERVER.allowVanillaCarvers.get()).booleanValue()) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203609_a(carverStage, carver));
                    continue;
                }
                if (!((Boolean)WBConfig.SERVER.allowModdedCarvers.get()).booleanValue()) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_203609_a(carverStage, carver));
            }
        }
    }

    private static void addBiomeNaturalMobs(Biome biome) {
        for (EntityClassification entityClass : EntityClassification.values()) {
            for (Biome.SpawnListEntry spawnEntry : biome.func_76747_a(entityClass)) {
                if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SPAWN, Registry.field_212629_r.func_177774_c((Object)spawnEntry.field_200702_b)) || !WBBiomes.BLENDED_BIOME.func_76747_a(entityClass).stream().noneMatch(spawn -> spawn.field_200702_b == spawnEntry.field_200702_b)) continue;
                if (Registry.field_212629_r.func_177774_c((Object)spawnEntry.field_200702_b) != null && Registry.field_212629_r.func_177774_c((Object)spawnEntry.field_200702_b).func_110624_b().equals("minecraft")) {
                    if (!((Boolean)WBConfig.SERVER.allowVanillaSpawns.get()).booleanValue()) continue;
                    WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_201866_a(entityClass, spawnEntry));
                    continue;
                }
                if (!((Boolean)WBConfig.SERVER.allowModdedSpawns.get()).booleanValue()) continue;
                WBBiomes.biomes.forEach(blendedBiome -> blendedBiome.func_201866_a(entityClass, spawnEntry));
            }
        }
    }

    private static void addBiomeSurfaceConfig(Biome biome) {
        if (biome.getRegistryName() != null && biome.getRegistryName().func_110624_b().equals("minecraft") ? (Boolean)WBConfig.SERVER.allowVanillaSurfaces.get() == false : (Boolean)WBConfig.SERVER.allowModdedSurfaces.get() == false) {
            return;
        }
        if (biome.func_203944_q() instanceof SurfaceBuilderConfig) {
            SurfaceBuilderConfig surfaceConfig = (SurfaceBuilderConfig)biome.func_203944_q();
            if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, surfaceConfig.func_204108_a().func_177230_c().getRegistryName())) {
                return;
            }
            if (!((BlendedSurfaceBuilder)WBBiomes.BLENDED_SURFACE_BUILDER).containsConfig(surfaceConfig)) {
                ((BlendedSurfaceBuilder)WBBiomes.BLENDED_SURFACE_BUILDER).addConfig(surfaceConfig);
            }
        } else {
            ISurfaceBuilderConfig surfaceConfig = biome.func_203944_q();
            if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, surfaceConfig.func_204108_a().func_177230_c().getRegistryName())) {
                return;
            }
            if (!((BlendedSurfaceBuilder)WBBiomes.BLENDED_SURFACE_BUILDER).containsConfig(surfaceConfig)) {
                ((BlendedSurfaceBuilder)WBBiomes.BLENDED_SURFACE_BUILDER).addConfig(surfaceConfig);
            }
        }
    }
}

