/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityAfricanLion;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderAfricanLion
extends RenderLivingZAWA<EntityAfricanLion>
implements IBabyModel<EntityAfricanLion> {
    public static final ResourceLocation simba = new ResourceLocation("zawa:textures/entity/african_lion/simba.png");
    public static final ResourceLocation simbaAdult = new ResourceLocation("zawa:textures/entity/african_lion/simba_adult.png");
    public static final ResourceLocation lionC = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby1.png");
    public static final ResourceLocation lion2C = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby2.png");
    public static final ResourceLocation lion3C = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby3.png");
    public static final ResourceLocation lion4C = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby4.png");
    public static final ResourceLocation lion5C = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby5.png");
    public static final ResourceLocation lion6C = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby6.png");
    public static final ResourceLocation blink = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_blink_1_3.png");
    public static final ResourceLocation blink2 = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_blink_2_4.png");
    public static final ResourceLocation blink3 = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_blink_5_6.png");
    public static final ResourceLocation babyBlink1 = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby_blink_1_3.png");
    public static final ResourceLocation babyBlink2 = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby_blink_2_4.png");
    public static final ResourceLocation babyBlink3 = new ResourceLocation("zawa:textures/entity/african_lion/african_lion_baby_blink_5_6.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAfricanLion(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.AFRICAN_LION, 0.7f);
        RenderConstants.AFRICAN_LION.setRig(new CMFRig(RenderConstants.AFRICAN_LION, new ResourceLocation("zawa", "models/entity/bengal_tiger/tiger.rig")));
        RenderConstants.AFRICAN_LION.setAnimator(RenderBengalTiger.TigerAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityAfricanLion entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.3f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    protected ResourceLocation getEntityTexture(EntityAfricanLion animal) {
        return this.getTextureOfVar(animal);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityAfricanLion animal) {
        String s = TextFormatting.func_110646_a((String)animal.func_70005_c_());
        if (s != null && s.equals("Simba")) {
            return animal.func_70631_g_() ? simba : simbaAdult;
        }
        if (ModuleManager.GENDER.getGender(animal) == Gender.MALE) {
            return CONTAINER.get(AbstractZawaLand.getVariant(animal));
        }
        return CONTAINER.get("female", AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAfricanLion entity) {
        if (entity.func_70631_g_()) {
            switch (AbstractZawaLand.getVariant(entity)) {
                default: {
                    return babyBlink1;
                }
                case 2: 
                case 4: {
                    return babyBlink2;
                }
                case 5: 
                case 6: 
            }
            return babyBlink3;
        }
        switch (AbstractZawaLand.getVariant(entity)) {
            default: {
                return blink;
            }
            case 2: 
            case 4: {
                return blink2;
            }
            case 5: 
            case 6: 
        }
        return blink3;
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.AFRICAN_LION_BABY.setAnimator(RenderBengalTiger.BabyTigerAnimator::new);
        return RenderConstants.AFRICAN_LION_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAfricanLion e) {
        String s = TextFormatting.func_110646_a((String)e.func_70005_c_());
        if (s != null && s.equals("Simba")) {
            return e.func_70631_g_() ? simba : simbaAdult;
        }
        switch (AbstractZawaLand.getVariant(e)) {
            default: {
                return lionC;
            }
            case 1: {
                return lion2C;
            }
            case 2: {
                return lion3C;
            }
            case 3: {
                return lion4C;
            }
            case 4: {
                return lion5C;
            }
            case 5: 
        }
        return lion6C;
    }

    static {
        CONTAINER.addResource("textures/entity/african_lion/african_lion_1.png");
        CONTAINER.addResource("textures/entity/african_lion/african_lion_2.png");
        CONTAINER.addResource("textures/entity/african_lion/african_lion_3.png");
        CONTAINER.addResource("textures/entity/african_lion/african_lion_4.png");
        CONTAINER.addResource("textures/entity/african_lion/african_lion_5.png");
        CONTAINER.addResource("textures/entity/african_lion/african_lion_6.png");
        CONTAINER.addResource("female", "textures/entity/african_lion/african_lion_female1.png");
        CONTAINER.addResource("female", "textures/entity/african_lion/african_lion_female2.png");
        CONTAINER.addResource("female", "textures/entity/african_lion/african_lion_female3.png");
        CONTAINER.addResource("female", "textures/entity/african_lion/african_lion_female4.png");
        CONTAINER.addResource("female", "textures/entity/african_lion/african_lion_female5.png");
        CONTAINER.addResource("female", "textures/entity/african_lion/african_lion_female6.png");
    }
}

