/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityAmurLeopard;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderAmurLeopard
extends RenderLivingZAWA<EntityAmurLeopard>
implements IBabyModel<EntityAmurLeopard> {
    public static final ResourceLocation blink = new ResourceLocation("zawa:textures/entity/amur_leopard/amur_leopard_baby_blink_1to2_4-5.png");
    public static final ResourceLocation blink2 = new ResourceLocation("zawa:textures/entity/amur_leopard/amur_leopard_baby_blink_3_6.png");
    public static final ResourceLocation blink3 = new ResourceLocation("zawa:textures/entity/amur_leopard/amur_leopard_baby_blink_7.png");
    public static final ResourceLocation blink4 = new ResourceLocation("zawa:textures/entity/amur_leopard/amur_leopard_blink_1to2_4to5.png");
    public static final ResourceLocation blink5 = new ResourceLocation("zawa:textures/entity/amur_leopard/amur_leopard_blink_3_6.png");
    public static final ResourceLocation blink6 = new ResourceLocation("zawa:textures/entity/amur_leopard/amur_leopard_blink_7.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderAmurLeopard(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.AMUR_LEOPARD, 0.4f);
        RenderConstants.AMUR_LEOPARD.setAnimator(RenderBengalTiger.TigerAnimator::new);
        RenderConstants.AMUR_LEOPARD_BABY.setAnimator(LeopardBabyAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityAmurLeopard e, float partialTickTime) {
        GlStateManager.func_179139_a((double)0.76, (double)0.76, (double)0.76);
        if (!e.isAsleep() && e.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.18f, (float)0.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)-0.3f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityAmurLeopard entity) {
        if (entity.func_70631_g_()) {
            switch (AbstractZawaLand.getVariant(entity)) {
                default: {
                    return blink;
                }
                case 3: 
                case 6: {
                    return blink2;
                }
                case 7: 
            }
            return blink3;
        }
        switch (AbstractZawaLand.getVariant(entity)) {
            default: {
                return blink4;
            }
            case 3: 
            case 6: {
                return blink5;
            }
            case 7: 
        }
        return blink6;
    }

    protected ResourceLocation getEntityTexture(EntityAmurLeopard entity) {
        return this.getTextureOfVar(entity);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityAmurLeopard e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.AMUR_LEOPARD_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityAmurLeopard e) {
        return CONTAINER.get("baby", AbstractZawaLand.getVariant(e));
    }

    static {
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard.png");
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard_2.png");
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard_3.png");
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard_4.png");
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard_5.png");
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard_6.png");
        CONTAINER.addResource("textures/entity/amur_leopard/amur_leopard_7.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby_2.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby_3.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby_4.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby_5.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby_6.png");
        CONTAINER.addResource("baby", "textures/entity/amur_leopard/amur_leopard_baby_7.png");
    }

    public static class LeopardAnimator
    extends ZAWAAnimator<EntityAmurLeopard> {
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("Thigh Left");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("Thigh Right");
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartByName("Arm Base Left");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartByName("Arm Base Right");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("neck");
        private final BookwormModelRenderer tail1 = this.getModel().getPartByName("tail1");
        private final BookwormModelRenderer tail2 = this.getModel().getPartByName("tail2");
        private final BookwormModelRenderer mouth = this.getModel().getPartByName("mouth");
        private final BookwormModelRenderer Body = this.getModel().getPartByName("Body");

        public LeopardAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAmurLeopard entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 1.8f;
            this.degree = 2.1f;
            this.neck.field_78795_f = f4 / 57.295776f - 0.3f;
            this.neck.field_78796_g = f3 / 57.295776f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f - 0.2f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -0.8f) * f1 * 0.5f - 0.2f;
            this.ArmBaseLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -0.8f) * f1 * 0.5f + 0.2f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f + 0.2f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.0962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.3f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + 0.0f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAmurLeopard entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            f = entity.field_70173_aa;
            f1 = 0.1f;
            this.speed = 1.0f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.5f;
            this.tail2.field_78808_h = MathHelper.func_76134_b((float)(21.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1162f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.3f;
        }
    }

    public static class LeopardBabyAnimator
    extends ZAWAAnimator<EntityAmurLeopard> {
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("tight1");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("tight2");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("tight4");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("tight3");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("neck");
        private final BookwormModelRenderer tail1 = this.getModel().getPartByName("tail1");
        private final BookwormModelRenderer tail2 = this.getModel().getPartByName("tail2");
        private final BookwormModelRenderer mouth = this.getModel().getPartByName("mouth");

        public LeopardBabyAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityAmurLeopard entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 1.8f;
            this.degree = 2.1f;
            this.neck.field_78795_f = f4 / 57.295776f - 0.1f;
            this.neck.field_78796_g = f3 / 57.295776f;
            this.tight1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f + 0.1f;
            this.tight2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -0.8f) * f1 * 0.5f + 0.1f;
            this.tight3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * -0.8f) * f1 * 0.5f - 0.1f;
            this.tight4.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.8f) * f1 * 0.5f - 0.1f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(10.0f + f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f;
            this.tail2.field_78808_h = MathHelper.func_76134_b((float)(21.0f + f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.0962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f + 0.1f;
        }
    }
}

