/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityBlackRhinoceros;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderBlackRhinoceros
extends RenderLivingZAWA<EntityBlackRhinoceros>
implements IBabyModel<EntityBlackRhinoceros> {
    public static final ResourceLocation blink = new ResourceLocation("zawa:textures/entity/black_rhinoceros/black_rhinoceros_blink_1_3_4_and_baby.png");
    public static final ResourceLocation blink2 = new ResourceLocation("zawa:textures/entity/black_rhinoceros/black_rhinoceros_blink_2.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderBlackRhinoceros(RenderManager m) {
        super(m, (ModelBase)RenderConstants.RHINOCEROS, 0.7f);
        RhinoAnimator a = new RhinoAnimator(RenderConstants.RHINOCEROS, 0.1f, 0.0f);
        a.neckWeight = -0.3f;
        RenderConstants.RHINOCEROS.setAnimator(e -> a);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityBlackRhinoceros entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.4f, (float)0.0f);
            if (entitylivingbaseIn.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179152_a((float)1.2f, (float)1.2f, (float)1.2f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.3f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityBlackRhinoceros entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 0);
        }
        if (AbstractZawaLand.getVariant(entity) == 1) {
            return CONTAINER.get("blink", 1);
        }
        return CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityBlackRhinoceros entity) {
        return this.getTextureOfVar(entity);
    }

    @Override
    public ResourceLocation getTextureOfVar(EntityBlackRhinoceros e) {
        return CONTAINER.get(AbstractZawaLand.getVariant(e));
    }

    @Override
    public ModelBase getBabyModel() {
        RhinoAnimator a = new RhinoAnimator(RenderConstants.BLACK_RHINO_BABY, 0.1f, 0.0f);
        a.neckWeight = -0.3f;
        return RenderConstants.BLACK_RHINO_BABY.setAnimator(e -> a);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityBlackRhinoceros e) {
        return this.getTextureOfVar(e);
    }

    static {
        CONTAINER.addResource("textures/entity/black_rhinoceros/black_rhinoceros.png");
        CONTAINER.addResource("textures/entity/black_rhinoceros/black_rhinoceros_2.png");
        CONTAINER.addResource("textures/entity/black_rhinoceros/black_rhinoceros_3.png");
        CONTAINER.addResource("textures/entity/black_rhinoceros/black_rhinoceros_4.png");
        CONTAINER.addResource("baby", "textures/entity/black_rhinoceros/black_rhinoceros_baby.png");
        CONTAINER.addResource("blink", "textures/entity/black_rhinoceros/black_rhinoceros_blink_1_3_4_and_baby.png");
        CONTAINER.addResource("blink", "textures/entity/black_rhinoceros/black_rhinoceros_blink_2.png");
    }

    public static class RhinoAnimator
    extends RenderBengalTiger.TigerAnimator {
        public RhinoAnimator(ModelCMF model) {
            super(model);
        }

        public RhinoAnimator(ModelCMF a, float v, float v1) {
            super(a, v, v1);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.speed = 12.4f;
            this.degree = 1.0f;
            if (entity instanceof EntityBlackRhinoceros && !entity.func_70631_g_() && ((EntityBlackRhinoceros)entity).getLying()) {
                this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.RHINOCEROS_SLEEPING);
            }
        }
    }
}

