/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityCoconutCrab;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderCoconutCrab
extends RenderLivingZAWA<EntityCoconutCrab>
implements IBabyModel<EntityCoconutCrab> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderCoconutCrab(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.CRAB.setAnimator(CrabAnimator::new), 0.4f);
    }

    @Override
    public boolean canBlink() {
        return false;
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityCoconutCrab e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.0f, (float)0.2f);
        } else {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.09f, (float)0.0f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityCoconutCrab animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.CRAB_BABY.setAnimator(CrabBabyAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityCoconutCrab e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/coconut_crab/coconut_crab.png");
        CONTAINER.addResource("textures/entity/coconut_crab/coconut_crab_2.png");
        CONTAINER.addResource("textures/entity/coconut_crab/coconut_crab_3.png");
        CONTAINER.addResource("textures/entity/coconut_crab/coconut_crab_4.png");
        CONTAINER.addResource("baby", "textures/entity/coconut_crab/crab_baby.png");
    }

    public static class CrabBabyAnimator
    extends ZAWAAnimator<EntityCoconutCrab> {
        private final BookwormModelRenderer RightArm = this.getModel().getPartByName("RightArm");
        private final BookwormModelRenderer LeftArm = this.getModel().getPartByName("LeftArm");
        private final BookwormModelRenderer FrontLeftLeg = this.getModel().getPartByName("FrontLeftLeg");
        private final BookwormModelRenderer FrontRightLeg = this.getModel().getPartByName("FrontRightLeg");
        private final BookwormModelRenderer BackLeftLeg = this.getModel().getPartByName("BackLeftLeg");
        private final BookwormModelRenderer BackRightLeg = this.getModel().getPartByName("BackRightLeg");

        public CrabBabyAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityCoconutCrab entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            float speed = 3.4f;
            float degree = 0.8f;
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * speed * 0.3f + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f + -0.1f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * speed * 0.3f + (float)Math.PI)) * (degree * -0.3f) * f1 * 0.5f + -0.1f;
            this.FrontLeftLeg.field_78796_g = MathHelper.func_76134_b((float)(1.3f + f * speed * 0.3f + (float)Math.PI)) * (degree * 1.2f) * f1 * 0.5f + 0.7f;
            this.FrontRightLeg.field_78796_g = MathHelper.func_76134_b((float)(1.3f + f * speed * 0.3f + (float)Math.PI)) * (degree * 1.2f) * f1 * 0.5f + -0.7f;
            this.BackLeftLeg.field_78796_g = MathHelper.func_76134_b((float)(1.3f + f * speed * 0.3f + (float)Math.PI)) * (degree * -1.2f) * f1 * 0.5f;
            this.BackRightLeg.field_78796_g = MathHelper.func_76134_b((float)(1.3f + f * speed * 0.3f + (float)Math.PI)) * (degree * -1.2f) * f1 * 0.5f;
        }
    }

    public static class CrabAnimator
    extends ZAWAAnimator<EntityCoconutCrab> {
        private final BookwormModelRenderer legLeft1Base = this.getModel().getPartByName("legLeft1Base");
        private final BookwormModelRenderer legLeft2Base = this.getModel().getPartByName("legLeft2Base");
        private final BookwormModelRenderer legLeft3Base = this.getModel().getPartByName("legLeft3Base");
        private final BookwormModelRenderer legLeft1 = this.getModel().getPartByName("legLeft1");
        private final BookwormModelRenderer legLeft2 = this.getModel().getPartByName("legLeft2");
        private final BookwormModelRenderer legRight1Base = this.getModel().getPartByName("legRight1Base");
        private final BookwormModelRenderer legRight2Base = this.getModel().getPartByName("legRight2Base");
        private final BookwormModelRenderer legRight3Base = this.getModel().getPartByName("legRight3Base");
        private final BookwormModelRenderer legRight1 = this.getModel().getPartByName("legRight1");
        private final BookwormModelRenderer legRight2 = this.getModel().getPartByName("legRight2");
        private final BookwormModelRenderer ArmRightBase = this.getModel().getPartByName("ArmRightBase");
        private final BookwormModelRenderer ArmLeftBase = this.getModel().getPartByName("ArmLeftBase");
        private final BookwormModelRenderer AntennaRight1 = this.getModel().getPartByName("AntennaRight1");
        private final BookwormModelRenderer AntennaLeft1 = this.getModel().getPartByName("AntennaLeft1");

        public CrabAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityCoconutCrab entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            float speed = 10.4f;
            float degree = 0.3f;
            this.legLeft1Base.field_78796_g = MathHelper.func_76134_b((float)(f * speed * 0.1f + (float)Math.PI)) * (degree * 2.5f) * f1 * 0.5f + 0.8f;
            this.legLeft2Base.field_78796_g = MathHelper.func_76134_b((float)(4.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 2.5f) * f1 * 0.5f + 0.1f;
            this.legLeft3Base.field_78796_g = MathHelper.func_76134_b((float)(3.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 2.5f) * f1 * 0.5f + -0.5f;
            this.legLeft1.field_78808_h = MathHelper.func_76134_b((float)(5.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 3.5f) * f1 * 0.5f + -0.5f;
            this.legLeft2.field_78808_h = MathHelper.func_76134_b((float)(f * speed * 0.1f + (float)Math.PI)) * (degree * 0.9f) * f1 * 0.5f + -0.3f;
            this.legRight1Base.field_78796_g = MathHelper.func_76134_b((float)(f * speed * 0.1f + (float)Math.PI)) * (degree * 2.5f) * f1 * 0.5f + -0.8f;
            this.legRight2Base.field_78796_g = MathHelper.func_76134_b((float)(4.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 2.5f) * f1 * 0.5f + -0.1f;
            this.legRight3Base.field_78796_g = MathHelper.func_76134_b((float)(3.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 2.5f) * f1 * 0.5f + 0.5f;
            this.legRight1.field_78808_h = MathHelper.func_76134_b((float)(5.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 3.5f) * f1 * 0.5f + 0.5f;
            this.legRight2.field_78808_h = MathHelper.func_76134_b((float)(f * speed * 0.1f + (float)Math.PI)) * (degree * 0.9f) * f1 * 0.5f + 0.3f;
            this.ArmRightBase.field_78795_f = MathHelper.func_76134_b((float)(f * speed * 0.1f + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f;
            this.ArmLeftBase.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f;
            this.AntennaLeft1.field_78795_f = MathHelper.func_76134_b((float)(f * speed * 0.1f + (float)Math.PI)) * (degree * 0.2f) * f1 * 0.5f + -0.2f;
            this.AntennaRight1.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * speed * 0.1f + (float)Math.PI)) * (degree * 0.2f) * f1 * 0.5f + -0.2f;
        }
    }
}

