/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityCommonChimp;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderCommonChimpanzee
extends RenderLivingZAWA<EntityCommonChimp>
implements IBabyModel<EntityCommonChimp> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderCommonChimpanzee(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.CHIMP, 0.4f);
        RenderConstants.CHIMP.setAnimator(ChimpAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityCommonChimp entity) {
        if (AbstractZawaLand.getVariant(entity) == 1 || AbstractZawaLand.getVariant(entity) == 3) {
            return CONTAINER.get("blink", 1);
        }
        return CONTAINER.get("blink", 0);
    }

    @Override
    protected void preRenderCallback(EntityCommonChimp entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
        if (!entitylivingbaseIn.isAsleep()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.04f, (float)0.0f);
        }
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            if (!entitylivingbaseIn.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.4f, (float)0.0f);
            }
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityCommonChimp animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.CHIMP_BABY.setAnimator(ChimpAnimator::new);
        return RenderConstants.CHIMP_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityCommonChimp e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/common_chimp/common_chimpanzee_1.png");
        CONTAINER.addResource("textures/entity/common_chimp/common_chimpanzee_2.png");
        CONTAINER.addResource("textures/entity/common_chimp/common_chimpanzee_3.png");
        CONTAINER.addResource("textures/entity/common_chimp/common_chimpanzee_4.png");
        CONTAINER.addResource("textures/entity/common_chimp/common_chimpanzee_5.png");
        CONTAINER.addResource("baby", "textures/entity/common_chimp/common_chimpanzee_baby.png");
        CONTAINER.addResource("blink", "textures/entity/common_chimp/common_chimpanzee_blink_1_3_5_baby.png");
        CONTAINER.addResource("blink", "textures/entity/common_chimp/common_chimpanzee_blink_2_4.png");
    }

    public static class ChimpAnimator
    extends ZAWAAnimator<EntityCommonChimp> {
        protected final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        protected final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        protected final BookwormModelRenderer mouth = this.getModel().getPartFromRig("Jaw");
        protected final BookwormModelRenderer ArmBaseRight = this.getModel().getPartFromRig("Arm Base Right");
        protected final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("Arm Right");
        protected final BookwormModelRenderer HandRight = this.getModel().getPartFromRig("Hand Left");
        protected final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartFromRig("Arm Left Base");
        protected final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("Arm Left");
        protected final BookwormModelRenderer HandLeft = this.getModel().getPartFromRig("Hand Left2");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("Thigh Right");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("Leg Right");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("Foot Right");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("Thigh Left");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("Leg Left");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("Foot Left");

        public ChimpAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityCommonChimp entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 0.4f;
            this.speed = 5.4f;
            this.neck.field_78795_f = f4 / 57.295776f - 0.4f;
            this.neck.field_78808_h = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.2962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.4f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(20.0f - f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f) * f1 * 0.5f - 0.2f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 1.4f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.2f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ArmBaseLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.05f;
            this.ArmBaseLeft.field_78795_f = -MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 1.4f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f - 0.2f;
            this.HandLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.ThighLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 3.3f) * f1 * 0.5f - 1.5f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 1.6f) * f1 * 0.5f + 0.4f;
            this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f) * f1 * 0.5f - 0.0f;
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 3.3f) * f1 * 0.5f - 1.5f;
            this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 1.6f) * f1 * 0.5f + 0.4f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1762f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 0.5f - 0.0f;
        }
    }
}

