/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityGalapagosTortoise;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderGalapagosTortoise
extends RenderLivingZAWA<EntityGalapagosTortoise>
implements IBabyModel<EntityGalapagosTortoise> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGalapagosTortoise(RenderManager m) {
        super(m, (ModelBase)RenderConstants.GALAPAGOS_TORTOISE, 0.5f);
        RenderConstants.GALAPAGOS_TORTOISE.setAnimator(GalapagosTortoiseAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGalapagosTortoise entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    protected void preRenderCallback(EntityGalapagosTortoise e, float partialTickTime) {
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        } else {
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        }
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityGalapagosTortoise entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GALAPAGOS_TORTOISE_BABY.setAnimator(GalapagosTortoiseAnimator::new);
        return RenderConstants.GALAPAGOS_TORTOISE_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGalapagosTortoise e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/galapagos_tortoise/galapagos_tortoise.png");
        CONTAINER.addResource("textures/entity/galapagos_tortoise/galapagos_tortoise_2.png");
        CONTAINER.addResource("textures/entity/galapagos_tortoise/galapagos_tortoise_3.png");
        CONTAINER.addResource("baby", "textures/entity/galapagos_tortoise/tortoise_baby.png");
        CONTAINER.addResource("blink", "textures/entity/galapagos_tortoise/tortoise_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/galapagos_tortoise/tortoise_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/galapagos_tortoise/tortoise_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/galapagos_tortoise/tortoise_blink_baby.png");
    }

    public static class GalapagosTortoiseAnimator
    extends ZAWAAnimator<EntityGalapagosTortoise> {
        private final BookwormModelRenderer LeftLeg = this.getModel().getPartByName("LeftLeg");
        private final BookwormModelRenderer RightLeg = this.getModel().getPartByName("RightLeg");
        private final BookwormModelRenderer BackRightLeg = this.getModel().getPartByName("BackRightLeg");
        private final BookwormModelRenderer BackLeftLeg = this.getModel().getPartByName("BackLeftLeg");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("NeckBase");
        private final BookwormModelRenderer Neck1 = this.getModel().getPartByName("Neck1");

        public GalapagosTortoiseAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGalapagosTortoise entity) {
            this.neck_part = this.Neck;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Neck.field_78795_f = f4 / 57.295776f - 0.3f;
            this.Neck.field_78796_g = f3 / 57.295776f;
            this.speed = 6.4f;
            this.degree = 0.6f;
            this.Neck1.field_78795_f = this.Neck.field_78795_f = -MathHelper.func_76134_b((float)(f * (0.2162f * this.speed) + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 0.5f - 0.3f;
            this.LeftLeg.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.6f) * f1 * 0.5f + 0.0f;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.6f) * f1 * 0.5f + 0.0f;
            this.BackLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.6f) * f1 * 0.5f + 0.0f;
            this.BackRightLeg.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.6f) * f1 * 0.5f + 0.0f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGalapagosTortoise entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Neck.field_78795_f = -MathHelper.func_76134_b((float)(f * 0.05886f + (float)Math.PI)) * (-this.degree * 0.6f) * f1 * 0.5f - 0.3f;
        }
    }
}

