/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityGrevysZebra;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderGrevysZebra
extends RenderLivingZAWA<EntityGrevysZebra>
implements IBabyModel<EntityGrevysZebra> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderGrevysZebra(RenderManager m) {
        super(m, (ModelBase)RenderConstants.GREVY_ZEBRA, 0.7f);
        RenderConstants.GREVY_ZEBRA.setRig(new CMFRig(RenderConstants.GREVY_ZEBRA, new ResourceLocation("zawa", "models/entity/grevy_zebra/zebra.rig")));
        RenderConstants.GREVY_ZEBRA_DEFAULT.setRig(new CMFRig(RenderConstants.GREVY_ZEBRA_DEFAULT, new ResourceLocation("zawa", "models/entity/grevy_zebra/zebra.rig")));
        RenderConstants.GREVY_ZEBRA.setAnimator(ZebraAnimator::new);
        this.func_177094_a(new LayerZebraSaddle(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityGrevysZebra e, float partialTickTime) {
        super.preRenderCallback(e, partialTickTime);
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            if (e.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
            }
        }
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityGrevysZebra entity) {
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityGrevysZebra entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GREVY_ZEBRA_BABY.setAnimator(ZebraBabyAnimator::new);
        return RenderConstants.GREVY_ZEBRA_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityGrevysZebra e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/grevyzebra/grevyzebra1.png");
        CONTAINER.addResource("textures/entity/grevyzebra/grevyzebra2.png");
        CONTAINER.addResource("textures/entity/grevyzebra/grevyzebra3.png");
        CONTAINER.addResource("textures/entity/grevyzebra/grevyzebra4.png");
        CONTAINER.addResource("baby", "textures/entity/grevyzebra/grevyzebrababy.png");
        CONTAINER.addResource("blink", "textures/entity/grevyzebra/grevyzebra_blink.png");
        CONTAINER.addResource("blink", "textures/entity/grevyzebra/grevyzebrababy_blink.png");
    }

    public static class ZebraBabyAnimator
    extends ZAWAAnimator<EntityGrevysZebra> {
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("tight1");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("tight2");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("tight31");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("tight3");

        public ZebraBabyAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGrevysZebra entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.tight1.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f + (float)Math.PI)) * 1.4f * f1;
            this.tight2.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f)) * 1.4f * f1;
            this.tight4.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f + (float)Math.PI)) * 1.4f * f1;
            this.tight3.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f)) * 1.4f * f1;
        }
    }

    public static class ZebraAnimator
    extends ZAWAAnimator<EntityGrevysZebra> {
        private final BookwormModelRenderer Body = this.getModel().getPartFromRig("Body");
        private final BookwormModelRenderer neck = this.getModel().getPartFromRig("Neck");
        private final BookwormModelRenderer tail2 = this.getModel().getPartFromRig("Tail2");
        private final BookwormModelRenderer tail1 = this.getModel().getPartFromRig("Tail1");
        private final BookwormModelRenderer mouth = this.getModel().getPartFromRig("Mouth");
        private final BookwormModelRenderer ArmBaseRight = this.getModel().getPartFromRig("ArmBaseRight");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartFromRig("ArmRight");
        private final BookwormModelRenderer HandRight = this.getModel().getPartFromRig("HandRight");
        private final BookwormModelRenderer ArmBaseLeft = this.getModel().getPartFromRig("ArmBaseLeft");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartFromRig("ArmLeft");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartFromRig("HandLeft");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartFromRig("ThighRight");
        private final BookwormModelRenderer UpperLegRight = this.getModel().getPartFromRig("UpperLegRight");
        private final BookwormModelRenderer LegRight = this.getModel().getPartFromRig("LegRight");
        private final BookwormModelRenderer FootRight = this.getModel().getPartFromRig("FootRight");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartFromRig("ThighLeft");
        private final BookwormModelRenderer UpperLegLeft = this.getModel().getPartFromRig("UpperLegLeft");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartFromRig("LegLeft");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartFromRig("FootLeft");
        private final BookwormModelRenderer LeftEar = this.getModel().getPartFromRig("LeftEar");
        private final BookwormModelRenderer RightEar = this.getModel().getPartFromRig("RightEar");

        public ZebraAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGrevysZebra e) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 2.2f;
            this.degree = 2.1f;
            if (e.func_184207_aI()) {
                f1 = 0.5f;
                this.speed = 1.3f;
                if (e.func_184179_bs() instanceof EntityLivingBase && ((EntityLivingBase)e.func_184179_bs()).field_191988_bg == 0.0f && ((EntityLivingBase)e.func_184179_bs()).field_70702_br == 0.0f) {
                    f1 = 0.0f;
                }
            }
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(f * (0.2762f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * 0.2f - 0.9f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.24f) * f1 * 0.1f + 0.0f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(12.0f + f * (0.2262f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f * -1.0f) * f1 * 0.5f;
            this.LeftEar.field_78796_g = MathHelper.func_76134_b((float)(32.0f + f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f;
            this.RightEar.field_78796_g = MathHelper.func_76134_b((float)(32.0f + f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f;
            this.degree = 0.9f;
            float aq = 0.03f;
            float ae = 0.3f;
            this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * aq - 0.05f;
            this.ArmBaseRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.4f) * f1 * ae - 0.1f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * ae + 0.0f;
            this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * ae - 0.0f;
            this.ArmBaseLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * aq - 0.05f;
            this.ArmBaseLeft.field_78795_f = -MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.4f) * f1 * ae - 0.1f;
            this.ArmLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * ae + 0.0f;
            this.HandLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * ae - 0.0f;
            this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * aq - 0.05f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * ae - 0.1f;
            this.UpperLegRight.field_78795_f = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * ae + 0.9f;
            this.LegRight.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * ae - 0.9f;
            this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * ae - 0.0f;
            this.ThighLeft.field_82908_p = -MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * aq - 0.05f;
            this.ThighLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * ae - 0.1f;
            this.UpperLegLeft.field_78795_f = -MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * ae + 0.9f;
            this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * ae - 0.9f;
            this.FootLeft.field_78795_f = -MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.3f) * f1 * ae - 0.0f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityGrevysZebra e) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, e);
            this.speed = 0.9f;
            this.degree = 1.0f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.3f - 0.9f;
            this.mouth.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.4f) * f1 * 0.3f + 0.1f;
            this.tail1.field_78808_h = MathHelper.func_76134_b((float)(12.0f + f * (0.1662f * this.speed) + (float)Math.PI)) * (this.degree * 0.6f * -1.0f) * f1 * 0.5f;
            this.LeftEar.field_78796_g = MathHelper.func_76134_b((float)(32.0f + f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * -1.0f) * f1 * 0.5f;
            this.RightEar.field_78796_g = MathHelper.func_76134_b((float)(32.0f + f * (0.2662f * this.speed) + (float)Math.PI)) * (this.degree * 0.2f * 1.0f) * f1 * 0.5f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerZebraSaddle
    implements LayerRenderer<EntityGrevysZebra> {
        private final ResourceLocation TEXTURE = new ResourceLocation("zawa:textures/entity/grevyzebra/saddle.png");
        private final RenderGrevysZebra render;

        public LayerZebraSaddle(RenderGrevysZebra re) {
            this.render = re;
        }

        public void doRenderLayer(EntityGrevysZebra e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (ModuleManager.SADDLE.isSaddled(e) && !e.func_82150_aj()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.03f, (float)0.0f);
                this.render.func_110776_a(this.TEXTURE);
                RenderConstants.GREVY_ZEBRA.func_178686_a(this.render.func_177087_b());
                RenderConstants.GREVY_ZEBRA.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)e);
                RenderConstants.GREVY_ZEBRA.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

