/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityIndianGharial;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderIndianGharial
extends RenderLivingZAWA<EntityIndianGharial>
implements IBabyModel<EntityIndianGharial> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderIndianGharial(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.GHARIAL.setAnimator(GharialAnimator::new), 0.4f);
        RenderConstants.GHARIAL_FEMALE.setAnimator(GharialAnimator::new);
    }

    @Override
    public void doRender(EntityIndianGharial entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = ModuleManager.GENDER.getGender(entity).equals((Object)Gender.MALE) ? RenderConstants.GHARIAL : RenderConstants.GHARIAL_FEMALE;
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityIndianGharial e, float partialTickTime) {
        super.preRenderCallback(e, partialTickTime);
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        } else if (AbstractZawaLand.Companion.getGender(e) == Gender.FEMALE) {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        }
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityIndianGharial entity) {
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    protected ResourceLocation getEntityTexture(EntityIndianGharial animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GHARIAL_BABY.setAnimator(GharialAnimator::new);
        return RenderConstants.GHARIAL_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityIndianGharial e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/indian_gharial/gharial.png");
        CONTAINER.addResource("textures/entity/indian_gharial/gharial_2.png");
        CONTAINER.addResource("textures/entity/indian_gharial/gharial_3.png");
        CONTAINER.addResource("textures/entity/indian_gharial/gharial_4.png");
        CONTAINER.addResource("baby", "textures/entity/indian_gharial/baby.png");
        CONTAINER.addResource("blink", "textures/entity/indian_gharial/gharial_blink.png");
        CONTAINER.addResource("blink", "textures/entity/indian_gharial/gharial_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/indian_gharial/gharial_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/indian_gharial/gharial_blink_4.png");
    }

    public static class GharialAnimator
    extends ZAWAAnimator<EntityIndianGharial> {
        protected final BookwormModelRenderer Body = this.getModel().getPartByName("Body");
        protected final BookwormModelRenderer UpperArmLeft = this.getModel().getPartByName("UpperArmLeft");
        protected final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("ArmLeft");
        protected final BookwormModelRenderer HandLeft = this.getModel().getPartByName("HandLeft");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("ThighLeft");
        protected final BookwormModelRenderer LegLeft = this.getModel().getPartByName("LegLeft");
        protected final BookwormModelRenderer FootLeft = this.getModel().getPartByName("FootLeft");
        protected final BookwormModelRenderer UpperArmRight = this.getModel().getPartByName("UpperArmRight");
        protected final BookwormModelRenderer ArmRight = this.getModel().getPartByName("ArmRight");
        protected final BookwormModelRenderer HandRight = this.getModel().getPartByName("HandRight");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartByName("ThighRight");
        protected final BookwormModelRenderer LegRight = this.getModel().getPartByName("LegRight");
        protected final BookwormModelRenderer FootRight = this.getModel().getPartByName("FootRight");
        protected final BookwormModelRenderer Tail1 = this.getModel().getPartByName("Tail1");
        protected final BookwormModelRenderer Tail2 = this.getModel().getPartByName("Tail2");
        protected final BookwormModelRenderer Tail3 = this.getModel().getPartByName("Tail3");
        protected final BookwormModelRenderer Tail4 = this.getModel().getPartByName("Tail4");
        protected final BookwormModelRenderer UpperJaw1 = this.getModel().getPartByName("UpperJaw1");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer Body2 = this.getModel().getPartByName("Body2");

        public GharialAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityIndianGharial entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.Neck.field_78795_f = f4 / 57.295776f;
            this.Neck.field_78796_g = f3 / 57.295776f;
            if (entity.func_70090_H()) {
                if (entity.func_70631_g_()) {
                    this.getModel().loadPosedModel((BookwormModelBase)RenderConstants.GHARIAL_BABY_SWIMMING);
                } else {
                    this.getModel().loadPosedModel((BookwormModelBase)(AbstractZawaLand.getGender(entity) == Gender.MALE ? RenderConstants.GHARIAL_SWIMMING : RenderConstants.GHARIAL_FEMALE_SWIMMING));
                }
                f = entity.field_70173_aa;
                f1 = 0.3f;
                this.speed = 1.0f;
                this.degree = 0.3f;
                this.Body.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * 2.0f * f1;
                this.Body.field_82906_o = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * -0.2f * f1;
                this.Body2.field_78796_g = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f)) * this.degree * 0.6f * f1;
                this.Neck.field_78796_g = MathHelper.func_76134_b((float)(3.0f + f * this.speed * 0.2f)) * this.degree * 2.0f * f1;
                this.Tail1.field_78796_g = MathHelper.func_76134_b((float)(-0.5f + f * this.speed * 0.2f)) * this.degree * 0.8f * f1;
                this.Tail2.field_78796_g = MathHelper.func_76134_b((float)(-1.0f + f * this.speed * 0.2f)) * this.degree * 0.8f * f1;
                this.Tail3.field_78796_g = MathHelper.func_76134_b((float)(-1.5f + f * this.speed * 0.2f)) * this.degree * 1.0f * f1;
                this.Tail4.field_78796_g = MathHelper.func_76134_b((float)(-2.0f + f * this.speed * 0.2f)) * this.degree * 1.0f * f1;
            } else {
                this.jaw_part = this.UpperJaw1;
                this.speed = 6.0f;
                this.degree = 2.0f;
                this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * this.speed * 0.24f)) * this.degree * 0.01f * f1 - 0.05f;
                this.UpperArmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * 0.3f * f1 - 0.1f;
                this.UpperArmLeft.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * 0.9f * f1 - 0.8f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.2f)) * this.degree * -0.4f * f1 + 0.7f;
                this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f)) * this.degree * 0.2f * f1 - 0.7f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.16f)) * this.degree * 0.5f * f1;
                this.ThighLeft.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.16f)) * this.degree * 0.5f * f1 + 1.0f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(0.8f + f * this.speed * 0.16f)) * this.degree * 0.3f * f1 - 0.55f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(1.5f + f * this.speed * 0.16f)) * this.degree * 0.4f * f1 - 0.6f;
                this.UpperArmRight.field_78795_f = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * -0.3f * f1 + 0.1f;
                this.UpperArmRight.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * 0.9f * f1 + 0.8f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.2f)) * this.degree * 0.4f * f1 + 0.7f;
                this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(2.0f + f * this.speed * 0.2f)) * this.degree * -0.2f * f1 - 0.8f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(1.0f + f * this.speed * 0.16f)) * this.degree * -0.5f * f1;
                this.ThighRight.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.16f)) * this.degree * 0.5f * f1 - 1.0f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(0.8f + f * this.speed * 0.16f)) * this.degree * -0.3f * f1 - 0.55f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(1.5f + f * this.speed * 0.16f)) * this.degree * -0.4f * f1 - 0.6f;
                this.Body.field_78796_g = MathHelper.func_76134_b((float)(f * this.speed * 0.2f)) * this.degree * 0.04f * f1;
                this.Tail1.field_78796_g = MathHelper.func_76134_b((float)(0.5f + f * this.speed * 0.2f)) * this.degree * 0.2f * f1;
                this.Tail2.field_78796_g = MathHelper.func_76134_b((float)(0.7f + f * this.speed * 0.2f)) * this.degree * 0.2f * f1;
                this.Tail3.field_78796_g = MathHelper.func_76134_b((float)(0.8f + f * this.speed * 0.2f)) * this.degree * 0.2f * f1;
                this.Tail4.field_78796_g = MathHelper.func_76134_b((float)(0.9f + f * this.speed * 0.2f)) * this.degree * 0.2f * f1;
            }
        }
    }
}

