/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityKomodoDragon;
import org.zawamod.entity.land.EntityMarineIguana;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderMarineIguana
extends RenderLivingZAWA<EntityMarineIguana>
implements IBabyModel<EntityMarineIguana> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderMarineIguana(RenderManager m) {
        super(m, (ModelBase)RenderConstants.MARINE_IGUANA, 0.4f);
        RenderConstants.MARINE_IGUANA.setAnimator(IguanaAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityMarineIguana entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityMarineIguana entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityMarineIguana entity) {
        return entity.func_70631_g_() ? CONTAINER.get("baby", 1) : (AbstractZawaLand.getVariant(entity) == 0 || AbstractZawaLand.getVariant(entity) == 1 ? CONTAINER.get("blink", 0) : CONTAINER.get("blink", AbstractZawaLand.getVariant(entity)));
    }

    @Override
    public ResourceLocation getTextureOfVar(int variant) {
        return CONTAINER.get(variant);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.MARINE_IGUANA_BABY.setAnimator(IguanaAnimator::new);
        return RenderConstants.MARINE_IGUANA_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityMarineIguana e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/marine_iguana/marine_iguana.png");
        CONTAINER.addResource("textures/entity/marine_iguana/marine_iguana_2.png");
        CONTAINER.addResource("textures/entity/marine_iguana/marine_iguana_3.png");
        CONTAINER.addResource("textures/entity/marine_iguana/marine_iguana_4.png");
        CONTAINER.addResource("baby", "textures/entity/marine_iguana/marine_iguana_baby.png");
        CONTAINER.addResource("blink", "textures/entity/marine_iguana/marine_iguana_blink_12.png");
        CONTAINER.addResource("blink", "textures/entity/marine_iguana/marine_iguana_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/marine_iguana/marine_iguana_blink_4.png");
        CONTAINER.addResource("baby", "textures/entity/marine_iguana/marine_iguana_blink_baby.png");
    }

    public static class IguanaAnimator
    extends ZAWAAnimator<AbstractZawaLand> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("Body");
        private final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer Mouth = this.getModel().getPartByName("Mouth");
        private final BookwormModelRenderer UpperArmLeft = this.getModel().getPartByName("UpperArmLeft");
        private final BookwormModelRenderer UpperArmRight = this.getModel().getPartByName("UpperArmRight");
        private final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("ArmLeft");
        private final BookwormModelRenderer HandLeft = this.getModel().getPartByName("HandLeft");
        private final BookwormModelRenderer ArmRight = this.getModel().getPartByName("ArmRight");
        private final BookwormModelRenderer HandRight = this.getModel().getPartByName("HandRight");
        private final BookwormModelRenderer Tail1 = this.getModel().getPartByName("Tail1");
        private final BookwormModelRenderer Tail2 = this.getModel().getPartByName("Tail2");
        private final BookwormModelRenderer Tail3 = this.getModel().getPartByName("Tail3");
        private final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("ThighLeft");
        private final BookwormModelRenderer LegLeft = this.getModel().getPartByName("LegLeft");
        private final BookwormModelRenderer FootLeft = this.getModel().getPartByName("FootLeft");
        private final BookwormModelRenderer ThighRight = this.getModel().getPartByName("ThighRight");
        private final BookwormModelRenderer LegRight = this.getModel().getPartByName("LegRight");
        private final BookwormModelRenderer FootRight = this.getModel().getPartByName("FootRight");

        public IguanaAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            this.jaw_part = this.Mouth;
            this.neck_part = this.Neck;
            this.tail_part = this.Tail1;
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 1.0f;
            this.speed = 9.5f;
            float weight = 0.0f;
            boolean flag = true;
            if (entity instanceof EntityKomodoDragon) {
                this.speed = 3.0f;
                weight = 0.3f;
                this.degree = 0.7f;
                flag = false;
            }
            if (entity.func_70631_g_()) {
                this.speed = 2.5f;
            }
            this.Neck.field_78795_f = f4 / 57.295776f - 0.3f + weight;
            this.Neck.field_78796_g = f3 / 57.295776f;
            this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.3162f * this.speed) + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f - 0.03f;
            this.Body.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.2062f * this.speed) + (float)Math.PI)) * (this.degree * -0.1f) * f1 * 0.5f - 0.0f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(50.0f + f * (0.3062f * this.speed) + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f - 0.3f + weight;
            float q = 1.0f;
            if (!entity.func_70090_H() || !flag) {
                this.UpperArmRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
                this.UpperArmRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.6f) * f1 * 0.5f + 0.0f;
                this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.0f;
                this.HandRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 0.9f) * f1 * 0.5f - 0.0f;
                this.UpperArmLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f - 0.05f;
                this.UpperArmLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.6f) * f1 * 0.5f + 0.0f;
                this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f + 0.0f;
                this.HandLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 0.9f) * f1 * 0.5f - 0.0f;
                this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
                this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 2.1f) * f1 * 0.5f - 0.1f + 0.0f;
                this.LegRight.field_78795_f = MathHelper.func_76134_b((float)(100.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.8f) * f1 * 0.5f + 0.9f;
                this.FootRight.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.1f) * f1 * 0.5f - 0.1f;
                this.ThighLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.2462f * this.speed))) * f1 * 0.05f + 0.0f;
                this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(20.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 2.1f) * f1 * 0.5f - 0.1f + 0.0f;
                this.LegLeft.field_78795_f = MathHelper.func_76134_b((float)(100.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (-this.degree * 1.8f) * f1 * 0.5f + 0.9f;
                this.FootLeft.field_78795_f = MathHelper.func_76134_b((float)(40.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * 1.1f) * f1 * 0.5f - 0.0f;
            } else if (flag) {
                f = entity.field_70173_aa;
                f1 = 0.25f;
                this.speed = 2.0f;
                this.degree = 2.5f;
                this.getModel().loadPosedModel((BookwormModelBase)(entity.func_70631_g_() ? RenderConstants.MARINE_IGUANA_BABY_SWIMMING : RenderConstants.MARINE_IGUANA_SWIMMING));
                q = 0.0f;
            }
            this.Tail1.field_78796_g = MathHelper.func_76134_b((float)(q * 50.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.4f) * f1 * 0.5f;
            this.Tail2.field_78796_g = MathHelper.func_76134_b((float)(q * 90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.4f) * f1 * 0.5f;
            this.Tail3.field_78796_g = MathHelper.func_76134_b((float)(q * 70.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.4f) * f1 * 0.5f;
        }

        @Override
        protected void performIdleAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performIdleAnimation(f, f1, f2, f3, f4, f5, entity);
            this.degree = 1.0f;
            this.speed = 0.4f;
            f = entity.field_70173_aa;
            f1 = 0.25f;
            this.Neck.field_78795_f = entity instanceof EntityKomodoDragon ? MathHelper.func_76134_b((float)(50.0f + f * (0.3062f * this.speed) + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f - 0.0f : MathHelper.func_76134_b((float)(50.0f + f * (0.3062f * this.speed) + (float)Math.PI)) * (this.degree * -0.2f) * f1 * 0.5f - 0.3f;
            this.Tail1.field_78796_g = MathHelper.func_76134_b((float)(50.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.4f) * f1 * 0.5f;
            this.Tail2.field_78796_g = MathHelper.func_76134_b((float)(90.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.4f) * f1 * 0.5f;
            this.Tail3.field_78796_g = MathHelper.func_76134_b((float)(70.0f + f * (0.1962f * this.speed) + (float)Math.PI)) * (this.degree * -0.4f) * f1 * 0.5f;
        }
    }
}

