/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.model.CMFRig;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.model.ModelMelon;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityNileHippo;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderNileHippopotamus
extends RenderLivingZAWA<EntityNileHippo>
implements IBabyModel<EntityNileHippo> {
    public static final ResourceLocation MELON = new ResourceLocation("zawa:textures/entity/melon.png");
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderNileHippopotamus(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.HIPPO, 0.6f);
        this.func_177094_a(new LayerMelon(this));
        Function<ModelCMF, CMFRig> rig = o -> new CMFRig(o, new ResourceLocation("zawa", "models/entity/hippo/hippo.rig"));
        RenderConstants.HIPPO.setRig(rig);
        RenderConstants.HIPPO_BABY.setRig(rig);
        RenderConstants.HIPPO_SLEEPING.setRig(rig);
        RenderConstants.HIPPO_BABY_SLEEPING.setRig(rig);
        RenderConstants.HIPPO.setAnimator(HippoAnimator::new);
        RenderConstants.HIPPO_BABY.setAnimator(HippoAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityNileHippo entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.03f, (float)-0.0f);
            GlStateManager.func_179152_a((float)1.25f, (float)1.25f, (float)1.25f);
        } else {
            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.0f, (float)0.0f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityNileHippo entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityNileHippo entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        return CONTAINER.get("blink", AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.HIPPO_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityNileHippo e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/nile_hippopotamus/nile_hippopotamus.png");
        CONTAINER.addResource("textures/entity/nile_hippopotamus/nile_hippopotamus_2.png");
        CONTAINER.addResource("textures/entity/nile_hippopotamus/nile_hippopotamus_3.png");
        CONTAINER.addResource("baby", "textures/entity/nile_hippopotamus/nile_hippopotamus_baby.png");
        CONTAINER.addResource("blink", "textures/entity/nile_hippopotamus/hippo_blink_1.png");
        CONTAINER.addResource("blink", "textures/entity/nile_hippopotamus/hippo_blink_2.png");
        CONTAINER.addResource("blink", "textures/entity/nile_hippopotamus/hippo_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/nile_hippopotamus/nile_hippopotamus_blink_baby.png");
    }

    public static class HippoAnimator
    extends RenderBengalTiger.TigerAnimator {
        public HippoAnimator(ModelCMF model) {
            super(model);
            this.neckWeight = 0.0f;
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, AbstractZawaLand entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            if (entity instanceof EntityNileHippo) {
                EntityNileHippo h = (EntityNileHippo)entity;
                this.Body.field_82908_p = MathHelper.func_76134_b((float)(f * (0.0162f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f;
                this.ArmBaseRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.0162f * this.speed))) * f1 * 0.05f - 0.05f;
                this.ArmBaseLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.0162f * this.speed))) * f1 * 0.05f - 0.05f;
                this.ThighRight.field_82908_p = MathHelper.func_76126_a((float)(f * (0.0162f * this.speed))) * f1 * 0.05f - 0.05f;
                this.ThighLeft.field_82908_p = MathHelper.func_76126_a((float)(f * (0.0162f * this.speed))) * f1 * 0.05f - 0.05f;
                if (h.getTemped() || h.getHoldingMelon() || h.isRunning()) {
                    this.mouth.field_78795_f = (float)Math.toRadians(41.74);
                    this.neck.field_78795_f = (float)Math.toRadians(-7.83);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerMelon
    implements LayerRenderer<EntityNileHippo> {
        private final RenderNileHippopotamus render;
        private final ModelMelon melon = new ModelMelon();

        public LayerMelon(RenderNileHippopotamus re) {
            this.render = re;
        }

        public void doRenderLayer(EntityNileHippo kat, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (!kat.func_82150_aj() && kat.getHoldingMelon()) {
                GlStateManager.func_179114_b((float)34.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.9f, (float)-2.3f);
                this.render.func_110776_a(MELON);
                this.melon.func_178686_a(this.render.func_177087_b());
                this.melon.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)kat);
                this.melon.func_78088_a((Entity)kat, f, f1, f2, f3, f4, f6);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

