/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.water.EntityOctopus;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderOctopus
extends RenderLivingZAWA<EntityOctopus> {
    public static final ResourceLocation PACIFIC = new ResourceLocation("zawa", "textures/entity/octopus/pacific.png");
    public static final ResourceLocation WHITE = new ResourceLocation("zawa", "textures/entity/octopus/white.png");
    public static final ResourceLocation REEF = new ResourceLocation("zawa", "textures/entity/octopus/reef.png");
    public static final ResourceLocation MIMIC = new ResourceLocation("zawa", "textures/entity/octopus/mimic.png");
    public static final ResourceLocation COMMON = new ResourceLocation("zawa", "textures/entity/octopus/common.png");
    public static final ResourceLocation BLUE = new ResourceLocation("zawa", "textures/entity/octopus/blue.png");
    public static final ResourceLocation CALIFORNIA = new ResourceLocation("zawa", "textures/entity/octopus/california.png");

    public RenderOctopus(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.OCTOPUS, 0.3f);
        RenderConstants.OCTOPUS.setAnimator(OctopusAnimator::new);
        RenderConstants.COMMON_OCTOPUS.setAnimator(OctopusAnimator::new);
        this.func_177094_a(new LayerOctopus(this));
    }

    @Override
    protected void preRenderCallback(EntityOctopus ent, float partialTickTime) {
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (ent.func_70090_H() && !ent.field_70122_E && !ent.func_70631_g_()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.6f, (float)0.0f);
        }
        if (AbstractZawaLand.getVariant(ent) != 0) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
        }
        if (ent.func_70631_g_() && AbstractZawaLand.getVariant(ent) != 1) {
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        } else if (AbstractZawaLand.getVariant(ent) == 1) {
            if (ent.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
            }
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        } else if (AbstractZawaLand.getVariant(ent) == 0) {
            GlStateManager.func_179152_a((float)1.4f, (float)1.4f, (float)1.4f);
        }
        super.preRenderCallback(ent, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityOctopus animal) {
        if (!animal.func_70631_g_() && AbstractZawaLand.getVariant(animal) == 0) {
            return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
        }
        return BookwormRenderUtils.NONE;
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        switch (varient) {
            default: {
                return PACIFIC;
            }
            case 1: {
                return BLUE;
            }
            case 2: {
                return CALIFORNIA;
            }
            case 3: {
                return COMMON;
            }
            case 4: {
                return MIMIC;
            }
            case 5: {
                return REEF;
            }
            case 6: 
        }
        return WHITE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerOctopus
    implements LayerRenderer<EntityOctopus> {
        private final RenderOctopus render;

        public LayerOctopus(RenderOctopus re) {
            this.render = re;
        }

        public void doRenderLayer(EntityOctopus kat, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (!kat.func_82150_aj()) {
                GlStateManager.func_179094_E();
                this.render.func_110776_a(this.render.getTextureOfVar(AbstractZawaLand.getVariant(kat)));
                RenderConstants.COMMON_OCTOPUS.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)kat);
                RenderConstants.COMMON_OCTOPUS.func_178686_a(this.render.func_177087_b());
                RenderConstants.COMMON_OCTOPUS.func_78088_a((Entity)kat, f, f1, f2, f3, f4, f6);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }

    public static class OctopusAnimator
    extends ZAWAAnimator<EntityOctopus> {
        public OctopusAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, EntityOctopus e) {
            super.setRotationAngles(f, f1, f2, f3, f4, f5, e);
            if (e.getAnimator().getPlayingAnimation() == null && e.field_70122_E) {
                this.getModel().loadPosedModel((BookwormModelBase)(AbstractZawaLand.getVariant(e) == 0 ? RenderConstants.OCTOPUS_SIT : RenderConstants.COMMON_OCTOPUS_SIT));
            }
            e.getAnimator().updateModel((BookwormModelBase)this.getModel());
        }
    }
}

