/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityOkapi;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.ZAWAUtils;

@SideOnly(value=Side.CLIENT)
public class RenderOkapi
extends RenderLivingZAWA<EntityOkapi>
implements IBabyModel<EntityOkapi> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderOkapi(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.OKAPI, 0.7f);
        RenderConstants.OKAPI.setAnimator(RenderBengalTiger.TigerAnimator::new);
        if (RenderConstants.OKAPI.getAnimator() instanceof RenderBengalTiger.TigerAnimator) {
            ((RenderBengalTiger.TigerAnimator)RenderConstants.OKAPI.getAnimator()).neckWeight = 5.0f;
        }
        this.func_177094_a(new LayerOkapiSaddle(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityOkapi entitylivingbaseIn, float partialTickTime) {
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.4f);
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.5f);
            if (entitylivingbaseIn.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
            }
        }
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityOkapi entity) {
        return CONTAINER.get("blink", 0);
    }

    protected ResourceLocation getEntityTexture(EntityOkapi animal) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.OKAPI_BABY.setAnimator(OkapiAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityOkapi e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/okapi/okapi1.png");
        CONTAINER.addResource("textures/entity/okapi/okapi2.png");
        CONTAINER.addResource("textures/entity/okapi/okapi3.png");
        CONTAINER.addResource("baby", "textures/entity/okapi/okapi_baby.png");
        CONTAINER.addResource("blink", "textures/entity/okapi/okapi_blink_and_baby.png");
    }

    public static class OkapiAnimator
    extends ZAWAAnimator<EntityOkapi> {
        private final BookwormModelRenderer tail = this.getModel().getPartByName("tail");
        private final BookwormModelRenderer tail_1 = this.getModel().getPartByName("tail1");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("Neck");
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("tight1");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("tight2");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("tight3");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("tight4");

        public OkapiAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityOkapi entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            if (entity.func_184179_bs() != null) {
                f1 = 0.3f;
                if (((EntityLivingBase)entity.func_184179_bs()).field_191988_bg == 0.0f && ((EntityLivingBase)entity.func_184179_bs()).field_70702_br == 0.0f) {
                    f1 = 0.0f;
                }
            }
            float speed = 2.4f;
            float degree = 2.1f;
            if (ZAWAConfig.clientOptions.livingAnimations && !ZAWAUtils.isEntityMoving((Entity)entity)) {
                speed = 1.8f;
                f = entity.field_70173_aa;
                f1 = 0.3f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(13.0f + f * (0.1122f * speed) + (float)Math.PI)) * (-degree * 0.1f) * f1 * 0.5f - 0.1f;
                this.tail.field_78808_h = MathHelper.func_76134_b((float)(53.0f + f * (0.1062f * speed) + (float)Math.PI)) * (degree * 0.6f) * f1 * 0.5f;
                this.tail_1.field_78808_h = MathHelper.func_76134_b((float)(63.0f + f * (0.1162f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f;
            } else {
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(13.0f + f * (0.1122f * speed) + (float)Math.PI)) * (-degree * 0.1f) * f1 * 0.5f - 0.1f;
                this.tight2.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.2262f * speed) + (float)Math.PI)) * (-degree * 0.4f) * f1 * 0.5f;
                this.tight1.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.2262f * speed) + (float)Math.PI)) * (degree * 0.4f) * f1 * 0.5f;
                this.tight3.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.2262f * speed) + (float)Math.PI)) * (-degree * 0.4f) * f1 * 0.5f;
                this.tight4.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.2262f * speed) + (float)Math.PI)) * (degree * 0.4f) * f1 * 0.5f;
                this.tail.field_78808_h = MathHelper.func_76134_b((float)(53.0f + f * (0.1062f * speed) + (float)Math.PI)) * (degree * 0.6f) * f1 * 0.5f;
                this.tail_1.field_78808_h = MathHelper.func_76134_b((float)(63.0f + f * (0.1162f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerOkapiSaddle
    implements LayerRenderer<EntityOkapi> {
        private final RenderOkapi render;
        private final ResourceLocation TEXTURE = new ResourceLocation("zawa:textures/entity/okapi/saddle.png");
        private final ModelCMF OKAPI_2 = RenderConstants.OKAPI.clone();

        public LayerOkapiSaddle(RenderOkapi re) {
            this.render = re;
        }

        public void doRenderLayer(EntityOkapi gaur, float p_177155_2_, float p_177155_3_, float p_177155_4_, float p_177155_5_, float p_177155_6_, float p_177155_7_, float p_177155_8_) {
            if (ModuleManager.SADDLE.isSaddled(gaur) && !gaur.func_82150_aj()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.15f);
                this.render.func_110776_a(this.TEXTURE);
                this.OKAPI_2.func_178686_a(this.render.func_177087_b());
                this.OKAPI_2.func_78088_a((Entity)gaur, p_177155_2_, p_177155_3_, p_177155_5_, p_177155_6_, p_177155_7_, p_177155_8_);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

