/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.RenderBengalTiger;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityPygmyHippo;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderPygmyHippo
extends RenderLivingZAWA<EntityPygmyHippo>
implements IBabyModel<EntityPygmyHippo> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderPygmyHippo(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.PYGMY_HIPPO, 0.6f);
        RenderConstants.PYGMY_HIPPO.setAnimator(RenderBengalTiger.TigerAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityPygmyHippo entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        switch (AbstractZawaLand.getVariant(entity)) {
            default: {
                CONTAINER.get("blink", 0);
            }
            case 2: {
                return CONTAINER.get("blink", 1);
            }
            case 3: 
        }
        return CONTAINER.get("blink", 2);
    }

    @Override
    protected void preRenderCallback(EntityPygmyHippo entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            if (!entitylivingbaseIn.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            if (!entitylivingbaseIn.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.1f);
            }
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityPygmyHippo entity) {
        return this.getTextureOfVar(AbstractZawaLand.getVariant(entity));
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.PYGMY_HIPPO_BABY.setAnimator(PygmyHippoAnimator::new);
        return RenderConstants.PYGMY_HIPPO_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityPygmyHippo e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/pygmy_hippo/pygmy_hippopotamus_1.png");
        CONTAINER.addResource("textures/entity/pygmy_hippo/pygmy_hippopotamus_2.png");
        CONTAINER.addResource("textures/entity/pygmy_hippo/pygmy_hippopotamus_3.png");
        CONTAINER.addResource("textures/entity/pygmy_hippo/pygmy_hippopotamus_4.png");
        CONTAINER.addResource("baby", "textures/entity/pygmy_hippo/pygmy_hippopotamus_baby.png");
        CONTAINER.addResource("blink", "textures/entity/pygmy_hippo/pygmy_hippopotamus_blink_1_2.png");
        CONTAINER.addResource("blink", "textures/entity/pygmy_hippo/pygmy_hippopotamus_blink_3.png");
        CONTAINER.addResource("blink", "textures/entity/pygmy_hippo/pygmy_hippopotamus_blink_4.png");
        CONTAINER.addResource("blink", "textures/entity/pygmy_hippo/pygmy_hippopotamus_baby_blink.png");
    }

    public static class PygmyHippoAnimator
    extends ZAWAAnimator<EntityPygmyHippo> {
        protected final BookwormModelRenderer Thigh1 = this.getModel().getPartFromRig("Thigh1");
        protected final BookwormModelRenderer neck = this.getModel().getPartFromRig("neck");
        protected final BookwormModelRenderer Thigh2 = this.getModel().getPartFromRig("Thigh2");
        protected final BookwormModelRenderer Thigh4 = this.getModel().getPartFromRig("Thigh4");
        protected final BookwormModelRenderer Thigh3 = this.getModel().getPartFromRig("Thigh3");
        protected final BookwormModelRenderer tail = this.getModel().getPartFromRig("tail");

        public PygmyHippoAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityPygmyHippo entity) {
            this.speed = 2.7f;
            this.degree = 2.1f;
            this.neck.field_78795_f = f3 / 57.295776f - 0.2f;
            this.neck.field_78796_g = f4 / 57.295776f;
            this.neck.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.2f;
            this.Thigh1.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f;
            this.Thigh2.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * -0.5f) * f1 * 0.5f;
            this.Thigh4.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * 0.5f) * f1 * 0.5f;
            this.Thigh3.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * -0.5f) * f1 * 0.5f;
            this.tail.field_78808_h = MathHelper.func_76134_b((float)(12.0f + f * (0.1462f * this.speed) + (float)Math.PI)) * (this.degree * -0.5f) * f1 * 0.5f;
            if (ZAWAConfig.clientOptions.livingAnimations && !BookwormUtils.isEntityMoving((Entity)entity)) {
                f = entity.field_70173_aa;
                f1 = 0.3f;
                this.neck.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.0862f * this.speed) + (float)Math.PI)) * (this.degree * 0.1f) * f1 * 0.5f - 0.2f;
                this.tail.field_78808_h = MathHelper.func_76134_b((float)(12.0f + f * (0.1062f * this.speed) + (float)Math.PI)) * (this.degree * -0.5f) * f1 * 0.5f;
            }
        }
    }
}

