/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityRedKangaroo;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderRedKangaroo
extends RenderLivingZAWA<EntityRedKangaroo>
implements IBabyModel<EntityRedKangaroo> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderRedKangaroo(RenderManager rm) {
        super(rm, (ModelBase)RenderConstants.RED_KANGAROO, 0.4f);
        RenderConstants.RED_KANGAROO.setAnimator(KangarooAnimator::new);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityRedKangaroo entity) {
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 3);
        }
        if (ModuleManager.GENDER.getGender(entity).equals((Object)Gender.MALE)) {
            return CONTAINER.get("blink", 0);
        }
        return AbstractZawaLand.getVariant(entity) == 1 ? CONTAINER.get("blink", 1) : CONTAINER.get("blink", 2);
    }

    @Override
    protected void preRenderCallback(EntityRedKangaroo e, float partialTickTime) {
        super.preRenderCallback(e, partialTickTime);
        GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
        if (e.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
            if (!e.isAsleep()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.25f);
    }

    protected ResourceLocation getEntityTexture(EntityRedKangaroo animal) {
        if (!animal.func_70631_g_()) {
            return ModuleManager.GENDER.getGender(animal).equals((Object)Gender.FEMALE) ? this.getTextureOfVar(AbstractZawaLand.getVariant(animal)) : this.getMaleTexture(AbstractZawaLand.getVariant(animal));
        }
        return BookwormRenderUtils.NONE;
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    public ResourceLocation getMaleTexture(int variant) {
        return CONTAINER.get("male", variant);
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.RED_KANGAROO_BABY.setAnimator(KangarooAnimator::new);
        return RenderConstants.RED_KANGAROO_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityRedKangaroo e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/red_kangaroo/redkangaroo_female_1.png");
        CONTAINER.addResource("textures/entity/red_kangaroo/redkangaroo_female_2.png");
        CONTAINER.addResource("textures/entity/red_kangaroo/redkangaroo_female_3.png");
        CONTAINER.addResource("male", "textures/entity/red_kangaroo/redkangaroo_male_1.png");
        CONTAINER.addResource("male", "textures/entity/red_kangaroo/redkangaroo_male_2.png");
        CONTAINER.addResource("male", "textures/entity/red_kangaroo/redkangaroo_male_3.png");
        CONTAINER.addResource("baby", "textures/entity/red_kangaroo/redkangaroo_baby.png");
        CONTAINER.addResource("blink", "textures/entity/red_kangaroo/redkangaroo_blink_male.png");
        CONTAINER.addResource("blink", "textures/entity/red_kangaroo/redkangaroo_blink_female_1.png");
        CONTAINER.addResource("blink", "textures/entity/red_kangaroo/redkangaroo_blink_female_23.png");
        CONTAINER.addResource("blink", "textures/entity/red_kangaroo/redkangaroo_blink_baby.png");
    }

    public static class KangarooAnimator
    extends ZAWAAnimator<EntityRedKangaroo> {
        public KangarooAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, EntityRedKangaroo e) {
            super.setRotationAngles(f, f1, f2, f3, f4, f5, e);
            e.getAnimator().updateModel((BookwormModelBase)this.getModel());
        }
    }
}

