/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import net.soggymustache.bookworm.util.BookwormUtils;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.model.ModelRedPanda;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.land.EntityRedPanda;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderRedPanda
extends RenderLivingZAWA<EntityRedPanda>
implements IBabyModel<EntityRedPanda> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderRedPanda(RenderManager rm) {
        super(rm, (ModelBase)new ModelRedPanda(), 0.4f);
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    protected void preRenderCallback(EntityRedPanda entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.2f);
        if (entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.1f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityRedPanda entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
        if (!entity.func_70631_g_() && s != null && s.replaceAll(" ", "").equalsIgnoreCase("mastershifu")) {
            return CONTAINER.get("blink", 0);
        }
        if (entity.func_70631_g_()) {
            return CONTAINER.get("blink", 2);
        }
        return AbstractZawaLand.getVariant(entity) == 1 ? CONTAINER.get("blink", 0) : CONTAINER.get("blink", 1);
    }

    protected ResourceLocation getEntityTexture(EntityRedPanda animal) {
        String s = TextFormatting.func_110646_a((String)animal.func_70005_c_());
        if (!animal.func_70631_g_()) {
            if (s != null && !s.equals("MasterShifu")) {
                return this.getTextureOfVar(AbstractZawaLand.getVariant(animal));
            }
            return CONTAINER.get("special", 0);
        }
        return BookwormRenderUtils.NONE;
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return CONTAINER.get(varient);
    }

    @Override
    public ModelBase getBabyModel() {
        return RenderConstants.RED_PANDA_BABY.setAnimator(RedPandaAnimator::new);
    }

    @Override
    public ResourceLocation getBabyTexture(EntityRedPanda e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/red_panda/red_panda.png");
        CONTAINER.addResource("textures/entity/red_panda/red_panda2.png");
        CONTAINER.addResource("textures/entity/red_panda/red_panda3.png");
        CONTAINER.addResource("special", "textures/entity/red_panda/red_panda_master_shifu.png");
        CONTAINER.addResource("baby", "textures/entity/red_panda/red_panda_baby.png");
        CONTAINER.addResource("blink", "textures/entity/red_panda/red_panda_blink_2_and_shifu.png");
        CONTAINER.addResource("blink", "textures/entity/red_panda/red_panda_blink_1_3.png");
        CONTAINER.addResource("blink", "textures/entity/red_panda/red_panda_baby_blink.png");
    }

    public static class RedPandaAnimator
    extends ZAWAAnimator<EntityRedPanda> {
        protected final BookwormModelRenderer Neck = this.getModel().getPartByName("Neck");
        protected final BookwormModelRenderer ThighLeft = this.getModel().getPartByName("ThighLeft");
        protected final BookwormModelRenderer ThighRight = this.getModel().getPartByName("ThighRight");
        protected final BookwormModelRenderer ArmLeft = this.getModel().getPartByName("ArmLeft");
        protected final BookwormModelRenderer ArmRight = this.getModel().getPartByName("ArmRight");
        protected final BookwormModelRenderer tailbase = this.getModel().getPartByName("tailbase");

        public RedPandaAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityRedPanda e) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, e);
            float speed = 2.3f;
            float degree = 2.1f;
            this.Neck.field_78795_f = f4 / 57.295776f - 0.1f;
            this.Neck.field_78796_g = f3 / 57.295776f;
            this.Neck.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.15f) * f1 * 0.5f - 0.1f;
            this.ThighLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.75f) * f1 * 0.5f - 0.1f;
            this.ThighRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * -0.75f) * f1 * 0.5f - 0.1f;
            this.ArmLeft.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * -0.75f) * f1 * 0.5f - 0.1f;
            this.ArmRight.field_78795_f = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.75f) * f1 * 0.5f - 0.1f;
            this.tailbase.field_78808_h = MathHelper.func_76134_b((float)(19.0f + f * (0.1162f * speed) + (float)Math.PI)) * (degree * 0.55f) * f1 * 0.5f;
            if (ZAWAConfig.clientOptions.livingAnimations && !BookwormUtils.isEntityMoving((Entity)e)) {
                f = e.field_70173_aa;
                f1 = 0.3f;
                this.Neck.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.0462f * speed) + (float)Math.PI)) * (degree * 0.15f) * f1 * 0.5f - 0.1f;
                this.tailbase.field_78808_h = MathHelper.func_76134_b((float)(19.0f + f * (0.0162f * speed) + (float)Math.PI)) * (degree * 0.55f) * f1 * 0.5f;
            }
        }
    }
}

