/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFAnimator;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.water.EntityFish;
import org.zawamod.entity.water.EntityTropicalFish;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderTropicalFish
extends RenderLivingZAWA<EntityTropicalFish> {
    public static final ResourceLocation texture = new ResourceLocation("zawa:textures/entity/tropical_fish/tropical_fish.png");
    public static final ResourceLocation eyes = new ResourceLocation("zawa:textures/entity/tropical_fish/tropical_fish_eyes.png");

    public RenderTropicalFish(RenderManager m) {
        super(m, (ModelBase)RenderConstants.TROPICAL_FISH.setAnimator(FishAnimator::new), 0.0f);
        this.func_177094_a(new LayerTropicalFish(this));
    }

    @Override
    protected void preRenderCallback(EntityTropicalFish e, float partialTickTime) {
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        super.preRenderCallback(e, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(EntityTropicalFish entity) {
        return this.getTextureOfVar(0);
    }

    @Override
    public ResourceLocation getTextureOfVar(int varient) {
        return BookwormRenderUtils.NONE;
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return null;
    }

    public static class FishAnimator
    extends CMFAnimator<EntityFish> {
        private final BookwormModelRenderer Body = this.getModel().getPartByName("Body");
        private final BookwormModelRenderer Head = this.getModel().getPartByName("Head");
        private final BookwormModelRenderer TailBase = this.getModel().getPartByName("Tail Base");
        private final BookwormModelRenderer Tail = this.getModel().getPartByName("Tail");
        private final BookwormModelRenderer Jaw = this.getModel().getPartByName("Jaw");
        private final BookwormModelRenderer FinLeft = this.getModel().getPartByName("Fin Left");
        private final BookwormModelRenderer FinRight = this.getModel().getPartByName("Fin Right");

        public FishAnimator(ModelCMF model) {
            super(model);
        }

        public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, EntityFish entity) {
            super.setRotationAngles(f, f1, f2, f3, f4, f5, (Entity)entity);
            this.getModel().reset();
            f = entity.field_70173_aa;
            f1 = 0.3f;
            float speed = 3.4f;
            float degree = 2.1f;
            this.Body.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.04f) * f1 * 0.5f;
            this.Head.field_78795_f = MathHelper.func_76134_b((float)(3.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f;
            this.TailBase.field_78795_f = MathHelper.func_76134_b((float)(-3.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.1f) * f1 * 0.5f;
            this.Tail.field_78796_g = MathHelper.func_76134_b((float)(f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.4f) * f1 * 0.5f;
            this.Jaw.field_78795_f = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f - 0.0f;
            this.FinLeft.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * 0.3f) * f1 * 0.5f + 0.2f;
            this.FinRight.field_78796_g = MathHelper.func_76134_b((float)(23.0f + f * (0.1462f * speed) + (float)Math.PI)) * (degree * -0.3f) * f1 * 0.5f - 0.2f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerTropicalFish
    implements LayerRenderer<EntityTropicalFish> {
        private final RenderTropicalFish render;

        public LayerTropicalFish(RenderTropicalFish renderIn) {
            this.render = renderIn;
        }

        public void doRenderLayer(EntityTropicalFish e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            GlStateManager.func_179094_E();
            this.render.func_110776_a(eyes);
            RenderConstants.TROPICAL_FISH.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)((float)e.getRed() / 255.0f), (float)((float)e.getGreen() / 255.0f), (float)((float)e.getBlue() / 255.0f), (float)1.0f);
            this.render.func_110776_a(texture);
            RenderConstants.TROPICAL_FISH.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
            GlStateManager.func_179121_F();
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

