/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.ModelCMF;
import net.soggymustache.bookworm.client.render.ResourceContainer;
import net.soggymustache.bookworm.common.entity.data.Gender;
import net.soggymustache.bookworm.util.BookwormRenderUtils;
import org.zawamod.client.IBabyModel;
import org.zawamod.client.ZAWAAnimator;
import org.zawamod.client.model.ModelWesternLowlandGorilla;
import org.zawamod.client.model.ModelWinston;
import org.zawamod.client.render.entity.base.RenderLivingZAWA;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.land.EntityLowlandGorilla;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderWesternLowlandGorilla
extends RenderLivingZAWA<EntityLowlandGorilla>
implements IBabyModel<EntityLowlandGorilla> {
    public static final ResourceContainer CONTAINER = new ResourceContainer("zawa");

    public RenderWesternLowlandGorilla(RenderManager rm) {
        super(rm, (ModelBase)new ModelWesternLowlandGorilla(), 0.7f);
        this.func_177094_a(new LayerWinston(this));
    }

    @Override
    public ResourceContainer getResourceContainer() {
        return CONTAINER;
    }

    @Override
    protected void preRenderCallback(EntityLowlandGorilla entitylivingbaseIn, float partialTickTime) {
        if (!entitylivingbaseIn.func_70631_g_()) {
            GlStateManager.func_179152_a((float)1.4f, (float)1.4f, (float)1.4f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.01f, (float)0.0f);
        } else {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
        }
        super.preRenderCallback(entitylivingbaseIn, partialTickTime);
    }

    @Override
    public boolean canBlink() {
        return true;
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityLowlandGorilla entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
        return entity.func_70631_g_() ? CONTAINER.get("blink", 1) : (s != null && !s.equals("Winston") ? CONTAINER.get("blink", 0) : BookwormRenderUtils.NONE);
    }

    protected ResourceLocation getEntityTexture(EntityLowlandGorilla animal) {
        String s = TextFormatting.func_110646_a((String)animal.func_70005_c_());
        if (s != null && !s.equals("Winston")) {
            if (ModuleManager.GENDER.getGender(animal) == Gender.MALE) {
                return CONTAINER.get(AbstractZawaLand.getVariant(animal));
            }
            return CONTAINER.get("female", AbstractZawaLand.getVariant(animal));
        }
        return BookwormRenderUtils.NONE;
    }

    @Override
    public ModelBase getBabyModel() {
        RenderConstants.GORILLA_BABY.setAnimator(GorillaBabyAnimator::new);
        return RenderConstants.GORILLA_BABY;
    }

    @Override
    public ResourceLocation getBabyTexture(EntityLowlandGorilla e) {
        return CONTAINER.get("baby", 0);
    }

    static {
        CONTAINER.addResource("textures/entity/western_lowland_gorilla/western_Lowland_gorilla_male_1.png");
        CONTAINER.addResource("textures/entity/western_lowland_gorilla/western_Lowland_gorilla_male_2.png");
        CONTAINER.addResource("textures/entity/western_lowland_gorilla/western_Lowland_gorilla_male_3.png");
        CONTAINER.addResource("female", "textures/entity/western_lowland_gorilla/western_Lowland_gorilla_female_1.png");
        CONTAINER.addResource("female", "textures/entity/western_lowland_gorilla/western_Lowland_gorilla_female_2.png");
        CONTAINER.addResource("female", "textures/entity/western_lowland_gorilla/western_Lowland_gorilla_female_3.png");
        CONTAINER.addResource("custom", "textures/entity/western_lowland_gorilla/winston.png");
        CONTAINER.addResource("blink", "textures/entity/western_lowland_gorilla/western_lowland_gorilla_blink_and_winston_and_baby.png");
        CONTAINER.addResource("blink", "textures/entity/western_lowland_gorilla/baby_blink.png");
        CONTAINER.addResource("baby", "textures/entity/western_lowland_gorilla/baby.png");
    }

    public static class GorillaBabyAnimator
    extends ZAWAAnimator<EntityLowlandGorilla> {
        private final BookwormModelRenderer tight1 = this.getModel().getPartByName("Arm");
        private final BookwormModelRenderer tight2 = this.getModel().getPartByName("Arm Right");
        private final BookwormModelRenderer tight4 = this.getModel().getPartByName("Thigh Right");
        private final BookwormModelRenderer tight3 = this.getModel().getPartByName("Thigh Left");
        private final BookwormModelRenderer neck = this.getModel().getPartByName("Head");

        public GorillaBabyAnimator(ModelCMF model) {
            super(model);
        }

        @Override
        protected void performGenericAnimation(float f, float f1, float f2, float f3, float f4, float f5, EntityLowlandGorilla entity) {
            super.performGenericAnimation(f, f1, f2, f3, f4, f5, entity);
            this.tight1.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f + (float)Math.PI)) * 1.4f * f1;
            this.tight2.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f)) * 1.4f * f1;
            this.tight4.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f + (float)Math.PI)) * 1.4f * f1;
            this.tight3.field_78795_f = MathHelper.func_76134_b((float)(f * 0.333f)) * 1.4f * f1;
            this.neck.field_78795_f = f4 / 57.295776f + 0.7f;
            this.neck.field_78796_g = f3 / 57.295776f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerWinston
    implements LayerRenderer<EntityLowlandGorilla> {
        private final RenderWesternLowlandGorilla render;
        private final ModelWinston modelF = new ModelWinston();

        public LayerWinston(RenderWesternLowlandGorilla re) {
            this.render = re;
        }

        public void doRenderLayer(EntityLowlandGorilla e, float f, float f1, float f2, float f3, float f4, float f5, float f6) {
            String s = TextFormatting.func_110646_a((String)e.func_70005_c_());
            if (s != null && s.equals("Winston") && !e.func_82150_aj()) {
                this.render.func_110776_a(CONTAINER.get("custom", 1));
                this.modelF.func_178686_a(this.render.func_177087_b());
                this.modelF.func_78087_a(f, f1, f3, f4, f5, f6, (Entity)e);
                this.modelF.func_78088_a((Entity)e, f, f1, f2, f3, f4, f6);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

