/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zawamod.ZAWAMain;
import org.zawamod.entity.general.EntityZAWAEgg;
import org.zawamod.util.EggData;
import org.zawamod.util.RenderConstants;

@SideOnly(value=Side.CLIENT)
public class RenderZAWAEgg
extends RenderLiving<EntityZAWAEgg> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("zawa", "textures/entity/egg/egg.png");
    private static final ResourceLocation CRACK1 = new ResourceLocation("zawa", "textures/entity/egg/egg_crack_1.png");
    private static final ResourceLocation CRACK2 = new ResourceLocation("zawa", "textures/entity/egg/egg_crack_2.png");
    private static final ResourceLocation CRACK3 = new ResourceLocation("zawa", "textures/entity/egg/egg_crack_3.png");

    public RenderZAWAEgg(RenderManager r) {
        super(r, (ModelBase)RenderConstants.EGG_BOTTOM, 0.2f);
        this.func_177094_a(new LayerEgg(this));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityZAWAEgg e) {
        if (ZAWAMain.proxy.getEggData().containsKey(e.getType()) && ZAWAMain.proxy.getEggData().get(e.getType()).getResource() != null) {
            return ZAWAMain.proxy.getEggData().get(e.getType()).getResource();
        }
        return TEXTURE;
    }

    protected void preRenderCallback(EntityZAWAEgg e, float partialTickTime) {
        super.func_77041_b((EntityLivingBase)e, partialTickTime);
        if (ZAWAMain.proxy.getEggData().containsKey(e.getType())) {
            EggData data = ZAWAMain.proxy.getEggData().get(e.getType());
            GlStateManager.func_179152_a((float)data.getScaleX(), (float)data.getScaleY(), (float)data.getScaleZ());
        }
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        if (e.isShaking()) {
            GlStateManager.func_179114_b((float)((float)(Math.sin(e.getShakeTime()) * 20.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void doRender(EntityZAWAEgg entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179108_z();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179133_A();
        GlStateManager.func_179121_F();
    }

    private static class LayerEgg
    implements LayerRenderer<EntityZAWAEgg> {
        private RenderZAWAEgg render;

        public LayerEgg(RenderZAWAEgg render) {
            this.render = render;
        }

        public void doRenderLayer(EntityZAWAEgg e, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (e.func_82150_aj()) {
                return;
            }
            this.render.func_110776_a(this.render.getEntityTexture(e));
            GlStateManager.func_179109_b((float)0.0f, (float)-0.187f, (float)0.0f);
            RenderConstants.EGG.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            ResourceLocation crack = null;
            if (e.crackState == 1) {
                crack = CRACK1;
            } else if (e.crackState == 2) {
                crack = CRACK2;
            } else if (e.crackState == 3) {
                crack = CRACK3;
            }
            if (crack != null) {
                this.render.func_110776_a(crack);
                RenderConstants.EGG.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.render.func_110776_a(crack);
                GlStateManager.func_179109_b((float)0.0f, (float)0.187f, (float)0.0f);
                RenderConstants.EGG_BOTTOM.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

