/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.configuration;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="zawa", name="ZooAndWildAnimalsRebuilt1.12.2-2.1.1/ZAWA1.12.2-2.1.1")
@Config.LangKey(value="config.zawa.title")
public class ZAWAConfig {
    public static final Options serverOptions = new Options();
    public static final ClientOptions clientOptions = new ClientOptions();

    @Mod.EventBusSubscriber(modid="zawa")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("zawa")) {
                ConfigManager.sync((String)"zawa", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Options {
        @Config.Name(value="ZAWA Attacking")
        @Config.Comment(value={"Set to 'false' to disable attacking in all difficulty modes"})
        public boolean enableAttacking = true;
        @Config.Name(value="Disable stats if server empty")
        @Config.Comment(value={"Prevents animals from losing stats if there is no one on the server"})
        public boolean disableStatsServerEmpty = false;
        @Config.Name(value="Net can only get tranquilized animals")
        @Config.Comment(value={"If the animal must be tranquilized (depending on its nature) in order to catch"})
        public boolean netTranq = true;
        @Config.Name(value="Max Random Kelp Height")
        public int kelpMax = 10;
        @Config.Name(value="Drinking Cooldown")
        @Config.Comment(value={"How long the animal has to wait before drinking again"})
        public int drinkingCooldown = 40;
        @Config.Name(value="Poacher Attacking")
        @Config.Comment(value={"If poachers should have attacking AI"})
        public boolean poacherAttacking = true;
        @Config.Name(value="Seine Net Drop Chance")
        @Config.Comment(value={"Random number to n == 0"})
        public int seineDrop = 10;
        @Config.Name(value="Seine Net Special Chance")
        @Config.Comment(value={"Random number to n == 0 | after the seineDrop is true this is called to give a vanilla fishing item"})
        public int seineDropSpecial = 20;
        @Config.Name(value="Worm Drop Chance")
        @Config.Comment(value={"Random number to n == 0"})
        public int wormChance = 20;
        @Config.Name(value="Food Barrel Search")
        @Config.Comment(value={"n in each direction away from the barrel"})
        public int barrelSearch = 7;
        @Config.Name(value="Entity Drops")
        @Config.Comment(value={"If animals should drop items"})
        public boolean drops = true;
        @Config.Name(value="ZAWA give care guide")
        @Config.Comment(value={"If the care guide should be given to players when they spawn"})
        public boolean giveGuide = true;
        @Config.Name(value="ZAWA Net Blacklist")
        @Config.Comment(value={"Resource locations of entities that cannot be captured in the animal net"})
        public String[] netBlacklist = new String[0];
        @Config.Name(value="ZAWA enrichment depreciation")
        @Config.Comment(value={"The amount enrichment for tamed animals should go down per tick"})
        @Config.RangeDouble(min=0.0)
        public double enrichmentDeprecation = 9.0E-4;
        @Config.Name(value="ZAWA care stats")
        @Config.Comment(value={"If zawa animals should enable stat handling. If this option is false, modules may not work properly/at all"})
        public boolean handleStats = true;
        @Config.Name(value="ZAWA interbreeding preventation")
        @Config.Comment(value={"If ZAWA animals will only breed with non-family members"})
        public boolean preventIncest = true;
        @Config.Name(value="ZAWA climbing")
        @Config.Comment(value={"If ZAWA animals can climb"})
        public boolean canClimb = true;
        @Config.Name(value="ZAWA spawning allowed")
        @Config.Comment(value={"If ZAWA animals can spawn"})
        public boolean canSpawn = true;
        @Config.Name(value="ZAWA experimental")
        @Config.Comment(value={"Enable experimental/buggy features early"})
        public boolean experimental = false;
        @Config.Name(value="ZAWA overworld only spawns")
        @Config.Comment(value={"If ZAWA animals can only spawn in the overworld"})
        public boolean overworldOnly = true;
        @Config.Name(value="ZAWA biome edits")
        @Config.Comment(value={"If ZAWA should put custom biome lists for modded biomes into the config on first generation (this shouldnt be an option because of how much we suggest leaving it on)"})
        public boolean biomeEdits = true;
    }

    public static class ClientOptions {
        @Config.Name(value="ZAWA idle animations")
        @Config.Comment(value={"If ZAWA animals will have an idle animation while not moving"})
        public boolean livingAnimations = true;
        @Config.Name(value="Last version")
        public String lastVersion = "1.12.2-2.1.1";
        @Config.Name(value="ZAWA experimental")
        @Config.Comment(value={"Enable experimental/buggy features early"})
        public boolean experimental = false;
        @Config.Name(value="ZAWA Flag")
        @Config.Comment(value={"Don't change unless you know what this does"})
        public int flag = 0;
    }
}

