/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalData;

public class EntityAIAdvancedWander
extends EntityAIBase {
    protected final AbstractZawaLand entity;
    protected double x;
    protected double y;
    protected double z;
    protected int timer;

    public EntityAIAdvancedWander(AbstractZawaLand creatureIn) {
        this.entity = creatureIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!((Boolean)this.entity.getWanderPredicate().invoke((Object)this.entity)).booleanValue()) {
            return false;
        }
        if (this.entity.getActivity() != AnimalData.Activity.NON_MOVING && this.entity.func_70681_au().nextInt(this.entity.getActivity().getChance()) != 0) {
            return false;
        }
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        if (!this.entity.getPack().isCanSwim()) {
            Vec3d vec3d = RandomPositionGenerator.func_191377_b((EntityCreature)this.entity, (int)15, (int)7);
            return vec3d;
        }
        return RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)10, (int)7);
    }

    public void func_75246_d() {
        super.func_75246_d();
        ++this.timer;
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public boolean func_75253_b() {
        return this.timer < 200 && !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.timer = 0;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, (double)this.entity.getSpeed());
        double d0 = this.x - this.entity.field_70165_t;
        double d2 = this.z - this.entity.field_70161_v;
        double d1 = this.y - this.entity.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        EntityLookHelper entitylookhelper = this.entity.func_70671_ap();
        double d7 = this.entity.field_70165_t + d0 / d3 * 2.0;
        double d8 = (double)this.entity.func_70047_e() + this.entity.field_70163_u + (d1 /= d3) / d3;
        double d9 = this.entity.field_70161_v + d2 / d3 * 2.0;
        double d10 = entitylookhelper.func_180423_e();
        double d11 = entitylookhelper.func_180422_f();
        double d12 = entitylookhelper.func_180421_g();
        if (!entitylookhelper.func_180424_b()) {
            d10 = d7;
            d11 = d8;
            d12 = d9;
        }
        this.entity.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
        this.entity.field_70761_aq = (float)MathHelper.func_181159_b((double)(d10 + (d7 - d10) * 0.125), (double)(d12 + (d9 - d12) * 0.125));
    }
}

