/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.base.ZAWABaseWater;
import org.zawamod.util.DataItem;
import org.zawamod.util.StringedItem;
import org.zawamod.util.status.StatusSwimming;

public abstract class ZAWABaseCrossover
extends AbstractZawaLand {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(ZAWABaseCrossover.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean ridden;
    private PathNavigate swimNavigator;
    private PathNavigate groundNavigator;

    public ZAWABaseCrossover(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.85f, 0.85f);
        this.field_70765_h = new SwimMoveHelper(this);
        this.swimNavigator = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
        this.groundNavigator = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusSwimming());
        return new DataItem(s);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, ZAWABaseWater.class, 12.0f, 0.01f));
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.ridden && !this.field_70170_p.field_72995_K && this.func_184188_bt().isEmpty() && player.func_184614_ca().func_190926_b()) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return super.func_175447_b(worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)Boolean.FALSE);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        }
        this.field_70699_by = this.func_70090_H() ? this.swimNavigator : this.groundNavigator;
        super.func_70636_d();
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public int func_70646_bf() {
        return 180;
    }

    @Override
    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(strafe, up, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.7999999761581421;
            this.field_70181_x *= 0.7999999761581421;
            this.field_70179_y *= 0.7999999761581421;
            if (this.field_70123_F) {
                this.field_70181_x = 0.07f;
            }
            if (!this.isMoving() && this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    static class SwimMoveHelper
    extends EntityMoveHelper {
        private final ZAWABaseCrossover swimmer;
        private int time;
        private float tar;

        public SwimMoveHelper(ZAWABaseCrossover swimmer) {
            super((EntityLiving)swimmer);
            this.swimmer = swimmer;
        }

        public void func_75641_c() {
            if (this.swimmer.func_70090_H()) {
                if (!this.swimmer.func_70661_as().func_75500_f()) {
                    double d0 = this.field_75646_b - this.swimmer.field_70165_t;
                    double d1 = this.field_75647_c - this.swimmer.field_70163_u;
                    double d2 = this.field_75644_d - this.swimmer.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    d1 /= d3;
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                    float limit = 80.0f;
                    if (Math.abs(this.field_75648_a.field_70759_as - this.tar) > 15.0f) {
                        this.time = 0;
                        this.tar = this.field_75648_a.field_70759_as;
                    } else {
                        ++this.time;
                        int speed = 30;
                        if (this.time > 30) {
                            limit = Math.max(1.0f - (float)(this.time - 30) / 30.0f, 0.0f) * 80.0f;
                        }
                    }
                    this.swimmer.field_70761_aq = this.swimmer.field_70177_z = (float)MathHelper.func_151238_b((double)this.field_75648_a.field_70761_aq, (double)f, (double)limit);
                    float f1 = (float)(this.field_75645_e * this.swimmer.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    this.swimmer.func_70659_e(this.swimmer.func_70689_ay() + (f1 - this.swimmer.func_70689_ay()) * 0.125f + 0.02f);
                    double d4 = Math.sin((double)(this.swimmer.field_70173_aa + this.swimmer.func_145782_y()) * 0.5) * 0.05;
                    double d5 = Math.cos(this.swimmer.field_70177_z * (float)Math.PI / 180.0f);
                    double d6 = Math.sin(this.swimmer.field_70177_z * (float)Math.PI / 180.0f);
                    d4 = Math.sin((double)(this.swimmer.field_70173_aa + this.swimmer.func_145782_y()) * 0.75) * 0.05;
                    this.swimmer.field_70181_x += d4 * (d6 + d5) * 0.25;
                    EntityLookHelper entitylookhelper = this.swimmer.func_70671_ap();
                    double d7 = this.swimmer.field_70165_t + d0 / d3 * 2.0;
                    double d8 = (double)this.swimmer.func_70047_e() + this.swimmer.field_70163_u + d1 / d3;
                    double d9 = this.swimmer.field_70161_v + d2 / d3 * 2.0;
                    double d10 = entitylookhelper.func_180423_e();
                    double d11 = entitylookhelper.func_180422_f();
                    double d12 = entitylookhelper.func_180421_g();
                    if (!entitylookhelper.func_180424_b()) {
                        d10 = d7;
                        d11 = d8;
                        d12 = d9;
                    }
                    this.swimmer.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                    this.swimmer.setMoving(true);
                } else {
                    Vec3d a = RandomPositionGenerator.func_75463_a((EntityCreature)this.swimmer, (int)15, (int)7);
                    if (a != null) {
                        this.swimmer.func_70661_as().func_75492_a(a.field_72450_a, a.field_72448_b, a.field_72449_c, this.field_75645_e);
                    }
                    this.swimmer.func_70659_e(0.0f);
                    this.swimmer.setMoving(false);
                }
            } else {
                super.func_75641_c();
            }
        }
    }
}

