/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.base;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.base.move.EntityBirdFlyHelper;
import org.zawamod.entity.core.UsableHandler;
import org.zawamod.entity.core.UsableObject;
import org.zawamod.entity.core.modules.ModuleManager;
import org.zawamod.entity.general.EntityBench;
import org.zawamod.init.ZAWAItems;

public abstract class ZAWABaseFlying
extends AbstractZawaLand
implements EntityFlying {
    public boolean shouldLand = false;
    public boolean grabbable = true;
    private int perchTicks = 0;
    protected int maxPerchTime = 120;
    public UsableObject<Block> currentRiding = UsableHandler.PERCH;
    public final PathNavigateFlying flyingNavigator;
    public final PathNavigateGround groundNavigator;
    public final EntityMoveHelper flyingMoveHelper;
    public final EntityMoveHelper groundMoveHelper;
    public EntityAISwimming aiSwimming;
    private int changeTimer;
    private boolean wantsToFly;

    public ZAWABaseFlying(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.grabbable = this.getPack().isBirdShoulder();
        this.flyingMoveHelper = new EntityBirdFlyHelper((EntityLiving)this);
        this.groundMoveHelper = new EntityMoveHelper((EntityLiving)this);
        this.flyingNavigator = new PathNavigateFlying((EntityLiving)this, worldIn);
        this.flyingNavigator.func_192879_a(false);
        this.flyingNavigator.func_192877_c(true);
        this.flyingNavigator.func_192878_b(true);
        this.groundNavigator = new PathNavigateGround((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.aiSwimming = new EntityAISwimming((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiSwimming);
    }

    public void func_70098_U() {
        Entity ridingEntity = this.func_184187_bx();
        if (ridingEntity instanceof EntityPlayer) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70071_h_();
            if (this.func_184218_aH() && ridingEntity.func_184196_w((Entity)this)) {
                this.field_70177_z = ((EntityPlayer)ridingEntity).field_70761_aq;
                this.field_70759_as = ((EntityPlayer)ridingEntity).field_70761_aq;
                this.field_70126_B = ((EntityPlayer)ridingEntity).field_70761_aq;
                float angle = 0.0174533f * ((EntityPlayer)ridingEntity).field_70761_aq + 165.0f;
                this.func_70107_b(ridingEntity.field_70165_t + (double)(0.4f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))), ridingEntity.field_70163_u + 1.4, ridingEntity.field_70161_v + (double)(0.4f * MathHelper.func_76134_b((float)angle)));
                if (ridingEntity.field_70122_E && ridingEntity.func_70093_af()) {
                    this.func_184210_p();
                }
            }
        } else {
            super.func_70098_U();
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.grabbable && this.func_70909_n() && this.isOwner(player) && player.func_184188_bt().isEmpty() && stack.func_77973_b() != ZAWAItems.DATA_BOOK) {
            this.func_184220_m((Entity)player);
        }
        return super.func_184645_a(player, hand);
    }

    protected boolean func_191957_ae() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (this.currentRiding == null) {
            this.currentRiding = UsableHandler.PERCH;
        }
        if (this.func_184187_bx() instanceof EntityBench) {
            ++this.perchTicks;
            if (ModuleManager.ENRICHMENT.lowEnrichment(this)) {
                ModuleManager.ENRICHMENT.onEnrich(this, this.currentRiding);
            } else if (this.perchTicks >= this.maxPerchTime) {
                this.perchTicks = 0;
                this.func_184210_p();
            }
        }
        if (!this.field_70122_E && this.isAsleep()) {
            this.setAsleep(false);
        }
        super.func_70071_h_();
        if (this.shouldHandleWater() && this.field_70171_ac) {
            this.shouldLand = false;
            Vec3d a = RandomPositionGenerator.func_191377_b((EntityCreature)this, (int)20, (int)7);
            if (a != null) {
                this.field_70181_x += (double)0.08f;
                this.func_70605_aq().func_75642_a(a.field_72450_a, a.field_72448_b, a.field_72449_c, 1.1);
            }
        }
        if (this.canFly()) {
            ++this.changeTimer;
            if (this.changeTimer > 50) {
                this.changeTimer = 0;
                boolean bl = this.wantsToFly = !this.wantsToFly;
            }
            if (!this.wantsToFly && this.field_70122_E && !this.field_70171_ac) {
                this.field_70699_by = this.groundNavigator;
                this.field_70765_h = this.groundMoveHelper;
            } else {
                this.field_70699_by = this.flyingNavigator;
                this.field_70765_h = this.flyingMoveHelper;
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.8);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.canFly()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.canFly()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public void setControl(int i) {
        super.setControl(i);
        if (this.getControl() == 1) {
            this.field_70699_by = this.groundNavigator;
            this.field_70765_h = this.groundMoveHelper;
        }
    }

    public boolean shouldHandleWater() {
        return true;
    }

    public boolean canFly() {
        return this.getControl() == 3 && !this.func_70631_g_() && !this.getEntityData().func_74767_n("NoFly");
    }
}

