/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.core;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.zawamod.entity.core.AnimalData;
import org.zawamod.entity.core.EntityDrop;
import org.zawamod.util.IntegerListAdapter;
import org.zawamod.util.ItemStackAdapter;
import org.zawamod.util.ResourceLocationAdapter;

public class AnimalPack {
    @SerializedName(value="swimming")
    private boolean canSwim = true;
    private List<EntityDrop> drops = new ArrayList<EntityDrop>();
    private float damage = 0.5f;
    private float speed = 1.0f;
    @SerializedName(value="distance_tolerance")
    private float distanceTolerance = 3.0f;
    @JsonAdapter(value=ResourceLocationAdapter.class)
    private List<ResourceLocation> targets = new ArrayList<ResourceLocation>();
    @SerializedName(value="max_health")
    private float maxHealth = 10.0f;
    private int variants = 1;
    @JsonAdapter(value=ItemStackAdapter.class)
    private ItemStack kibble = ItemStack.field_190927_a;
    @JsonAdapter(value=ItemStackAdapter.class)
    private ItemStack vial = ItemStack.field_190927_a;
    private AnimalData.EnumNature nature = AnimalData.EnumNature.NEUTRAL;
    @SerializedName(value="water_breathing")
    private boolean waterBreathing = false;
    private AnimalData.Activity activity = AnimalData.Activity.NORMAL;
    @SerializedName(value="mc_speed")
    private double mcSpeed = 0.23;
    @SerializedName(value="flee_speed")
    private float fleeSpeed = -1.0f;
    @SerializedName(value="step_height")
    private float stepHeight = 1.0f;
    private boolean transportable = true;
    private boolean controllable = false;
    @SerializedName(value="flip_sleep")
    private boolean flipSleep = false;
    @SerializedName(value="bird_shoulder")
    private boolean birdShoulder = true;
    @SerializedName(value="jump_upwards_motion")
    private float jumpUpwardsMotion = -1.0f;
    @SerializedName(value="mx_fall_height")
    private int maxFallHeight;
    @SerializedName(value="male_gender_percent")
    private float maleChance = 0.5f;
    @SerializedName(value="rare_variants")
    @JsonAdapter(value=IntegerListAdapter.class)
    private List<Integer> rareVariants = new ArrayList<Integer>();
    @SerializedName(value="breed_variants")
    @JsonAdapter(value=IntegerListAdapter.class)
    private List<Integer> breedVariants = new ArrayList<Integer>();
    @SerializedName(value="rare_variant_chance")
    private float rareVariantChance = 0.02f;
    @SerializedName(value="breed_variant_chance")
    private float breedVariantChance = 0.02f;
    @SerializedName(value="inheritance_chance")
    private float inheritanceChance = 0.6f;
    public List<Integer> variantsList = new ArrayList<Integer>();
    public List<Integer> variantsNoSpecial = new ArrayList<Integer>();

    public AnimalPack applyVariantSetup() {
        for (int i2 = 0; i2 < this.getVariants(); ++i2) {
            this.variantsList.add(i2);
        }
        this.variantsList.forEach(i -> {
            if (!this.getBreedVariants().contains(i) && !this.getRareVariants().contains(i)) {
                this.variantsNoSpecial.add((Integer)i);
            }
        });
        return this;
    }

    public boolean sleepingFlipped() {
        return this.flipSleep;
    }

    public void setFlipSleep(boolean flipSleep) {
        this.flipSleep = flipSleep;
    }

    public float getInheritanceChance() {
        return this.inheritanceChance;
    }

    public void setInheritanceChance(float inheritanceChance) {
        this.inheritanceChance = inheritanceChance;
    }

    public List<Integer> getVariantsNoSpecial() {
        return this.variantsNoSpecial;
    }

    public List<Integer> getVariantsList() {
        return this.variantsList;
    }

    public void setRareVariantChance(float rareVariantChance) {
        this.rareVariantChance = rareVariantChance;
    }

    public void setBreedVariantChance(float breedVariantChance) {
        this.breedVariantChance = breedVariantChance;
    }

    public List<Integer> getRareVariants() {
        return this.rareVariants;
    }

    public List<Integer> getBreedVariants() {
        return this.breedVariants;
    }

    public float getRareVariantChance() {
        return this.rareVariantChance;
    }

    public float getBreedVariantChance() {
        return this.breedVariantChance;
    }

    public float getMaleChance() {
        return this.maleChance;
    }

    public void setMaleChance(float maleChance) {
        this.maleChance = maleChance;
    }

    public void setFleeSpeed(float fleeSpeed) {
        this.fleeSpeed = fleeSpeed;
    }

    public void setStepHeight(float stepHeight) {
        this.stepHeight = stepHeight;
    }

    public void setTransportable(boolean transportable) {
        this.transportable = transportable;
    }

    public void setControllable(boolean controllable) {
        this.controllable = controllable;
    }

    public float getFleeSpeed() {
        return this.fleeSpeed;
    }

    public float getStepHeight() {
        return this.stepHeight;
    }

    public boolean isTransportable() {
        return this.transportable;
    }

    public boolean isControllable() {
        return this.controllable;
    }

    public float getSpeed() {
        return this.speed;
    }

    public double getMCSpeed() {
        return this.mcSpeed;
    }

    public boolean isCanSwim() {
        return this.canSwim;
    }

    public List<EntityDrop> getDrops() {
        return this.drops;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getDistanceTolerance() {
        return this.distanceTolerance;
    }

    public List<ResourceLocation> getTargets() {
        return this.targets;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public int getVariants() {
        return this.variants;
    }

    public ItemStack getKibble() {
        return this.kibble;
    }

    public ItemStack getVial() {
        return this.vial;
    }

    public AnimalData.EnumNature getNature() {
        return this.nature;
    }

    public boolean isWaterBreathing() {
        return this.waterBreathing;
    }

    public AnimalData.Activity getActivity() {
        return this.activity;
    }

    public void setCanSwim(boolean canSwim) {
        this.canSwim = canSwim;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setDistanceTolerance(float distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void getMaxVariants(int variants) {
        this.variants = variants;
    }

    public void setKibble(ItemStack kibble) {
        this.kibble = kibble;
    }

    public void getVial(ItemStack vial) {
        this.vial = vial;
    }

    public void getNature(AnimalData.EnumNature nature) {
        this.nature = nature;
    }

    public void setWaterBreathing(boolean waterBreathing) {
        this.waterBreathing = waterBreathing;
    }

    public void setActivity(AnimalData.Activity activity) {
        this.activity = activity;
    }

    public void setMcSpeed(double mcSpeed) {
        this.mcSpeed = mcSpeed;
    }

    public boolean isBirdShoulder() {
        return this.birdShoulder;
    }

    public float getJumpUpwardsMotion() {
        return this.jumpUpwardsMotion;
    }

    public int getMaxFallHeight() {
        return this.maxFallHeight;
    }

    public void setBirdShoulder(boolean birdShoulder) {
        this.birdShoulder = birdShoulder;
    }

    public void setJumpUpwardsMotion(float jumpUpwardsMotion) {
        this.jumpUpwardsMotion = jumpUpwardsMotion;
    }

    public void setMaxFallHeight(int maxFallHeight) {
        this.maxFallHeight = maxFallHeight;
    }
}

