/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.core.modules.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import org.zawamod.configuration.ZAWAModuleConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.UsableHandler;
import org.zawamod.entity.core.UsableObject;
import org.zawamod.entity.core.modules.AnimalModule;

public class UsableModule
extends AnimalModule<AbstractZawaLand> {
    private ZAWAModuleConfig.ModuleOption<Boolean> enabled = new ZAWAModuleConfig.ModuleOption<Boolean>(".Enabled", "Hunger", true).register();
    private ZAWAModuleConfig.ModuleOption<Integer> searchableSearchCooldown = new ZAWAModuleConfig.ModuleOption<Integer>("Searchable searching cool-down", "Hunger", 20).register();
    private ZAWAModuleConfig.ModuleOption<Integer> moveCooldown = new ZAWAModuleConfig.ModuleOption<Integer>("Move to cool-down", "Hunger", 30).register();
    public static final String MOVE_COOLDOWN = "moveCooldown";
    public static final String SEARCH_COOLDOWN = "searchCooldown";

    @Override
    public ZAWAModuleConfig.ModuleOption<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    public void entityConstructed(AbstractZawaLand entity) {
        super.entityConstructed(entity);
        entity.getAnimalInt().put(MOVE_COOLDOWN, 0);
        entity.getAnimalInt().put(SEARCH_COOLDOWN, 0);
    }

    @Override
    public void postLivingStatHandle(AbstractZawaLand entity) {
        super.postLivingStatHandle(entity);
        for (Map.Entry<Object, UsableObject<?>> entry : UsableHandler.USABLES.entrySet()) {
            Object key = entry.getKey();
            if (!entry.getValue().shouldUse.apply(entity).booleanValue() || !entry.getValue().STYLE.equals((Object)UsableObject.Style.BLOCK) || !(key instanceof Block)) continue;
            UsableObject<?> value = entry.getValue();
            if (!value.shouldUse.apply(entity).booleanValue()) continue;
            List<BlockPos> poses = entity.getSearchablePositions().get(entry.getValue());
            boolean needsSearch = false;
            if (poses != null && !poses.isEmpty()) {
                for (BlockPos pos : poses) {
                    if (entity.field_70170_p.func_180495_p(pos).func_177230_c() == key && entry.getValue().canUsePos.apply(entity, pos).booleanValue()) {
                        if (Math.sqrt(entity.func_174818_b(pos)) < (double)((float)entry.getValue().blockUseDistance / 2.0f)) {
                            entry.getValue().onUsePos.accept(entity, pos);
                            needsSearch = false;
                            continue;
                        }
                        if (Math.sqrt(entity.func_174818_b(pos)) < (double)((float)entry.getValue().blockUseDistance + (float)entry.getValue().blockUseDistance / 2.0f)) {
                            int cooldown = entity.getAnimalInt().get(MOVE_COOLDOWN);
                            if (cooldown <= 0) {
                                entity.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.26);
                                entity.getAnimalInt().put(MOVE_COOLDOWN, this.moveCooldown.getValue());
                            } else {
                                entity.getAnimalInt().put(MOVE_COOLDOWN, cooldown - 1);
                            }
                            needsSearch = false;
                            continue;
                        }
                        needsSearch = true;
                        continue;
                    }
                    needsSearch = true;
                }
                entity.getSearchablePositions().get(entry.getValue()).removeIf(i -> !UsableHandler.USABLES.containsKey(entity.field_70170_p.func_180495_p(i).func_177230_c()));
            } else {
                needsSearch = true;
            }
            int cool = entity.getAnimalInt().get(SEARCH_COOLDOWN);
            if (needsSearch && cool <= 0) {
                Iterable ps = BlockPos.func_177980_a((BlockPos)new BlockPos(entity.field_70165_t - (double)entry.getValue().blockUseDistance, entity.field_70163_u - (double)entry.getValue().blockUseDistance, entity.field_70161_v - (double)entry.getValue().blockUseDistance), (BlockPos)new BlockPos(entity.field_70165_t + (double)entry.getValue().blockUseDistance, entity.field_70163_u + (double)entry.getValue().blockUseDistance, entity.field_70161_v + (double)entry.getValue().blockUseDistance));
                ArrayList blocks = new ArrayList();
                ps.forEach(e -> blocks.add(entity.field_70170_p.func_180495_p(e).func_177230_c()));
                if (blocks.contains(key)) {
                    Set set = StreamSupport.stream(ps.spliterator(), false).collect(Collectors.toSet());
                    for (BlockPos pos : set) {
                        if (entry.getValue().OBJECT != entity.field_70170_p.func_180495_p(pos).func_177230_c()) continue;
                        entity.getSearchablePositions().computeIfAbsent(value, k -> new ArrayList());
                        if (entity.getSearchablePositions().get(entry.getValue()).contains(pos)) continue;
                        entity.getSearchablePositions().get(entry.getValue()).add(pos);
                    }
                }
                entity.getAnimalInt().put(SEARCH_COOLDOWN, this.searchableSearchCooldown.getValue());
            }
            if (cool <= 0) continue;
            entity.getAnimalInt().put(SEARCH_COOLDOWN, cool - 1);
        }
    }
}

