/*
 * Decompiled with CFR 0.152.
 */
package org.zawamod.entity.land;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.soggymustache.bookworm.client.animation.lerp.Animation;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import org.zawamod.configuration.ZAWAConfig;
import org.zawamod.entity.base.AbstractZawaLand;
import org.zawamod.entity.core.AnimalPack;
import org.zawamod.util.AnimalPackManager;
import org.zawamod.util.DataItem;
import org.zawamod.util.RenderConstants;
import org.zawamod.util.StringedItem;
import org.zawamod.util.ZAWASounds;
import org.zawamod.util.status.StatusClimbing;

public class EntityBlackSpiderMonkey
extends AbstractZawaLand {
    private boolean besideClimbable;

    public EntityBlackSpiderMonkey(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.9f);
    }

    @Override
    public AnimalPack getPack() {
        return AnimalPackManager.SPIDER_MONKEY;
    }

    @Override
    @Nullable
    public Animation getSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.SPIDER_MONKEY, RenderConstants.MONKEY_SLEEPING});
    }

    @Override
    @Nullable
    public Animation getChildSleepAnimation() {
        return new Animation(new BookwormModelBase[]{RenderConstants.SPIDER_MONKEY_BABY, RenderConstants.MONKEY_BABY_SLEEPING});
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.43));
    }

    @Override
    public DataItem getIconList() {
        ArrayList<StringedItem> s = new ArrayList<StringedItem>();
        s.add(new StatusClimbing());
        return new DataItem(s);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f - 0.1f;
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected SoundEvent func_184639_G() {
        return ZAWASounds.SPIDER_MONKEY_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ZAWASounds.SPIDER_MONKEY_HURT;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (EnumFacing facing : EnumFacing.values()) {
            Block block = this.field_70170_p.func_180495_p(this.func_180425_c().func_177972_a(facing)).func_177230_c();
            if (!this.isValidBlock(block)) continue;
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean isValidBlock(Block b) {
        return b instanceof BlockLog || b instanceof BlockLeaves || b instanceof BlockPlanks;
    }

    public boolean isBesideClimbableBlock() {
        return this.besideClimbable;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.besideClimbable = climbing;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock() && ZAWAConfig.serverOptions.canClimb;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityBlackSpiderMonkey(this.field_70170_p);
    }
}

